/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
/* 
 Author     : Proxima
 */

(function ($)
{
    $.extend({
        alert: function (parameters) {
            bootbox.dialog({
                message: parameters.msg,
                title: "Ouups!",
                buttons: {
                    dismiss: {
                        label: "Ok",
                        className: "btn-sm btn-primary"
                    }
                },
                onEscape: function () {
                    $.hideAll()
                }
            });
        },
        serverError: function () {
            $.hideAll();
            $.unblockPage();
            bootbox.dialog({
                message: "Une erreur est survenue. Veuillez contacter votre administrateur système. (Code: #500)",
                title: "Ouups!",
                buttons: {
                    dismiss: {
                        label: "Ok",
                        className: "btn-sm btn-primary"
                    }
                },
                onEscape: function () {
                    $.hideAll()
                }
            });
        },
        confirm: function (parameters, callback) {
            bootbox.dialog({
                message: parameters.msg,
                title: parameters.title,
                buttons: {
                    success: {
                        label: "Oui",
                        className: "btn-sm btn-default",
                        callback: function () {
                            callback(true)
                        }
                    },
                    danger: {
                        label: "Non",
                        className: "btn-sm btn-primary",
                        callback: function () {
                            callback(false)
                        }
                    }
                },
                onEscape: function () {
                    $.hideAll()
                }
            });
        },
        prompt: function (parameters, callback, def) {
            var def_form = parameters.label + ': <input id="popup-btn" type="text" />';
            if (typeof (def) == 'undefined') {
                def = true;
            }
            if (def == true) {
                bootbox.dialog({
                    message: def_form,
                    title: parameters.title,
                    buttons: {
                        success: {
                            label: "Ok",
                            className: "btn-sm btn-default",
                            callback: function () {
                                callback($('#popup-btn').val())
                            }
                        }
                    },
                    onEscape: function () {
                        $.hideAll()
                    }
                })
            } else if (def == false) {
                bootbox.dialog({
                    message: parameters.form,
                    title: parameters.title,
                    buttons: parameters.buttons,
                    onEscape: function () {
                        $.hideAll()
                    }
                })
            }
        },
        dialog: function (parameters) {
            bootbox.dialog({
                message: parameters.content,
                title: parameters.title,
                className: parameters.className,
                buttons: parameters.buttons,
                onEscape: function () {
                    $.hideAll()
                }
            });
        },
        hideAll: function () {
            bootbox.hideAll()
        },
        blockPage: function (time) {
            $.blockUI({message: ' '});
            NProgress.start();
        },
        unblockPage: function () {
            $.unblockUI();
            NProgress.done();
        }
    })
})(jQuery);