var Socials = function(parameters) {
    var _params = parameters;
    var obj = {
        page: {
            _reload: function() {
                window.location.href = _params.base_url + 'socials';
            }
        },
        entity: {
            _delete: function(id, title) {
                $.confirm({
                    title: "Confirmation de suppression",
                    msg: "Êtes-vous sûr de vouloir supprimer le réseau <b>"+title+"</b> ?"
                }, function(response){
                    if(response === true) {
                        $.ajax({
                            url: _params.base_url + 'delete-socials',
                            type: 'post',
                            data: {
                                id: id,
                                title: title
                            },
                            success: function() {
                                obj.page._reload();
                            }
                        });
                    }
                });
            },
            _bind: function() {
                $(document).on("click", ".btn-delete", function() {
                    obj.entity._delete($(this).attr('id'), $(this).attr('title'));
                });
                
            },
            _init: function() {
                obj.entity._bind();
            }
        }
    };
    return {
        /**
         * initializer
         * @returns {undefined}
         */
        init: function() {
            obj.entity._init();
        }
    };
};/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


