var Message = function(parameters) {
    var _params = parameters;
    var obj = {
        page: {
            _reload: function() {
                window.location.href = _params.base_url + 'messages';
            }
        },
        entity: {
            _delete: function(id, title) {
                $.confirm({
                    title: "Confirmation de suppression",
                    msg: "Êtes-vous sûr de vouloir supprimer le message \"" + title + "\" ?"
                }, function(response){
                    if(response === true) {
                        $.ajax({
                            url: _params.base_url + 'delete-message',
                            type: 'post',
                            data: {
                                id: id,
                                title: title
                            },
                            success: function() {
                                obj.page._reload()
                            }
                        });
                    }
                });
            },
            _bind: function() {
                $(document).on("click", ".btn-delete", function() {
                    obj.entity._delete($(this).attr('id'), $(this).attr('title'))
                })
                $(document).on('click', '.thumbnail-load', function() {
                    
                    var rsc = new Resource();
                    rsc.load(_params.theme_url, _params.base_url, 'Vignette', function(result) {
                        console.log(result);
                    });
                });
                
            },
            _init: function() {
                obj.entity._bind();
            }
        }
    };
    return {
        /**
         * initializer
         * @returns {undefined}
         */
        init: function() {
            obj.entity._init();
        }
    };
};