var Dropzone_resource = function(parameters) {
    var _params = parameters;
    
    var obj = {
        resource: {
            _add: function() {
                Dropzone.autoDiscover = false;
                var myDropzone = new Dropzone('#mydropzone', {
                    url: _params.base_url + 'resource/upload',
                    addRemoveLinks: true,
                    maxFilesize: 10,
                    dictRemoveFile: 'Supprimer',
                    dictDefaultMessage: 'Déposez des fichiers ici',
                    dictCancelUpload: 'Annuler téléchargement',
                    dictCancelUploadConfirmation: 'Vous ête sûr d\'annuler le téléchargement ?',
                    dictResponseError: 'Error uploading file!',
                });
                myDropzone.on('sending', function(file, xhr, formData) {
                        formData.append('csrf_token', $.cookie('strl_csrf_cookie_name'));
                });
                myDropzone.on('success', function(file, id) {
                    console.log(id)
                    var $file_ids = $('#files');

                    if ($file_ids.val() === '') {
                        $file_ids.val(id);
                    } else {
                        $file_ids.val($file_ids.val() + ',' + id);
                    }
                    file.resource_id = id;
                    return file.previewElement.classList.add('dz-success');
                });
                myDropzone.on('removedfile', function(file) {
                    $.ajax({
                        url: _params.base_url + 'resource/delete',
                        type: 'post',
                        data: {
                            'id': file.resource_id,
                            'csrf_token': $.cookie('strl_csrf_cookie_name')
                        },
                        success: function(response) {
                            //remove ressource id from input hidden
                            var files = $('#files'),
                                    arr = JSON.parse("[" + files.val() + "]");
                            arr = $.grep(arr, function(a) {
                                return a !== parseInt(file.resource_id);
                            });
                            files.val(arr.join(","));
                        }
                    });

                });
            },
            _update: function(base_url, upload_url, files) {
                Dropzone.autoDiscover = false;
                var myDropzone = new Dropzone('#mydropzone', {
                    url: _params.base_url + 'resource/upload',
                    addRemoveLinks: true,
                    maxFilesize: 50,
                    dictRemoveFile: 'Supprimer',
                    dictDefaultMessage: 'Déposez des fichiers ici',
                    dictCancelUpload: 'Annuler téléchargement',
                    dictCancelUploadConfirmation: 'Vous ête sûr d\'annuler le téléchargement ?',
                    dictResponseError: 'Error uploading file!'
                });
                myDropzone.on('sending', function(file, xhr, formData) {
                        formData.append('csrf_token', $.cookie('strl_csrf_cookie_name'));
                });
                myDropzone.on('success', function(file, id) {
                    var $file_ids = $('#files');

                    if ($file_ids.val() === '') {
                        $file_ids.val(id);
                    } else {
                        $file_ids.val($file_ids.val() + ',' + id);
                    }
                    file.resource_id = id;
                    return file.previewElement.classList.add('dz-success');
                });
                myDropzone.on('removedfile', function(file) {
                    $.ajax({
                        url: _params.base_url + 'resource/delete',
                        type: 'post',
                        data: {
                            'id': file.resource_id,
                            'csrf_token': $.cookie('strl_csrf_cookie_name')
                        },
                        success: function(response) {
                            //remove ressource id from input hidden
                            var files = $('#files'),
                                    arr = JSON.parse("[" + files.val() + "]");
                            arr = $.grep(arr, function(a) {
                                return a !== parseInt(file.resource_id);
                            });
                            files.val(arr.join(","));
                        }
                    });
                });
                files.forEach(function(file) {
                    // Create the mock file:
                    var mockFile = {name: 'image', size: file['size']};
                    mockFile.resource_id = file['id'];
                    // Call the default addedfile event handler
                    myDropzone.emit("addedfile", mockFile);

                    // And optionally show the thumbnail of the file:
                    if (file['mimeType'] !== 'application/pdf') {
                        myDropzone.emit("thumbnail", mockFile, file['full_url_path']);
                    }
                });
            }
        }
    };
    return {
        add: function() {

            obj.resource._add();
        },
        update: function(base_url, upload_url, files) {
            obj.resource._update(base_url, upload_url, files);
        }
    };
};