<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class MY_Controller extends CI_Controller {

    protected $layout = 'base';
    protected $meta = [];
    protected $stylesheets = [];
    protected $javascripts = [];
    protected $scripts = '';
    protected $local_meta = [];
    protected $local_stylesheets = [];
    protected $local_javascripts = [];
    protected $local_scripts = '';

    /**
     * Construct
     */
    public function __construct() {
        parent::__construct();
        check_ssl();
        $this->meta = [];
        $this->stylesheets = [
//            theme_url() . 'css/bootstrap.min.css',
//            theme_url() . 'css/magnific-popup.min.css',
//            theme_url() . 'css/owl.carousel.min.css',
//            theme_url() . 'css/owl.theme.min.css',
//            theme_url() . 'css/preloader.min.css',
//            theme_url() . 'css/theme.min.css',
//            theme_url() . 'css/responsive.min.css',
//            theme_url() . 'font-awesome/css/font-awesome.min.css',
        ];
        
        $this->javascripts = [
//            theme_url() . 'js/jquery.min.js',
//            'https://maps.googleapis.com/maps/api/js?sensor=true',
//            theme_url() . 'js/bootstrap.min.js',
//            theme_url() . 'js/jquery.magnific-popup.min.js',
//            theme_url() . 'js/retina.min.js',
//            theme_url() . 'js/smoothscroll.min.js',
//            theme_url() . 'js/theme-plugins.min.js',
//            theme_url() . 'js/scripts.min.js',
        ];

        $this->data = $this->getCommonViewData();
    }

    /**
     * Render a view into the base template
     * 
     * @param string $content
     */
    protected function render($content) {
        $view_data = array(
            'meta' => $this->get_meta(),
            'content' => $content,
            'stylesheets' => $this->get_stylesheets(),
            'javascripts' => $this->get_javascripts(),
            'scripts' => $this->get_scripts()
        );
        $this->load->view($this->layout, $view_data);
    }

    /**
     * Get view data
     * 
     * @return array
     */
    public function getData() {
        return array_merge($this->data, $this->local_data);
    }

    /**
     * Get Metas tag
     * 
     * @return array
     */
    protected function get_meta() {
        return array_merge($this->meta, $this->local_meta);
    }

    /**
     * Get stylesheets
     * 
     * @return array
     */
    protected function get_stylesheets() {
        return array_merge($this->stylesheets, $this->local_stylesheets);
    }

    /**
     * Get js plugins
     * 
     * @return array
     */
    protected function get_javascripts() {
        return array_merge($this->javascripts, $this->local_javascripts);
    }

    /**
     * Get scripts
     * 
     * @return string
     */
    protected function get_scripts() {
        return $this->scripts . chr(13) . $this->local_scripts;
    }

    /**
     * Get comment views data
     * 
     * @return array
     */
    protected function getCommonViewData() {
        return [
            'profile' => $this->getProfile(),
        ];
    }

    /**
     * Get Syndicat
     * 
     * @return array
     */
    protected function getProfile() {
        $em = $this->doctrine->em;
        $profile = $em->getRepository('Entities\Profile')->get();
      
        return $profile;
    }

 

 


}
