<!--main content start-->
<section id="main-content">
    <section class="wrapper">
        <div class="row">
            <div class="col-sm-12">
                <?= form_open(site_url('projects/' . $project['id'] . '/edit'), 'role="form"'); ?>
                <section class="panel">
                    <header class="panel-heading">
                        Modification d'un projet
                        <span class="tools pull-right">
                            <a href="javascript:;" class="fa fa-chevron-down"></a>
                        </span>
                    </header>
                    <div class="panel-body">
                        <div class="row">                          
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <label class="control-label" for="title">Publie :</label>
                                <input type="radio" value="1" name="active" <?php if($project['active']=="1"){?>checked<?php } ?> class="radio-button"> Oui
                                <input type="radio" value="0" name="active" <?php if($project['active']=="0"){?>checked<?php } ?> class="radio-button"> Non
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                                        <div class="form-group<?= (form_error('project[title]') ? ' has-error' : ''); ?>">
                                            <label class="control-label" for="title">Titre :</label>
                                            <?= (form_error('project[title]') ? form_error('project[title]', ' <span class="help-inline"> | ', '</span>') : ''); ?>
                                            <?= form_input('project[title]', set_value('project[title]', $project['title']), 'class="form-control" placeholder="Titre" htmlEscape="true"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                                        <div class="form-group<?= (form_error('project[position]') ? ' has-error' : ''); ?>">
                                            <label class="control-label" for="position">Position :</label>
                                            <?= (form_error('project[position]') ? form_error('project[position]', ' <span class="help-inline"> | ', '</span>') : ''); ?>
                                            <?= form_input('project[position]', set_value('project[position]', $project['position']), 'class="form-control" placeholder="Position" htmlEscape="true"'); ?>
                                        </div>
                                    </div>    
                                    <div class="col-lg-12 col-md-6 col-sm-6 col-xs-6">
                                        <div class="form-group<?= (form_error('project[description]') ? ' has-error' : ''); ?>">
                                            <label class="control-label" for="description">Description :</label>
                                            <?= (form_error('project[description]') ? form_error('project[description]', ' <span class="help-inline"> | ', '</span>') : ''); ?>
                                            <?= form_textarea(['name' => 'project[description]', 'rows' => '5', 'cols' => '5'], set_value('project[description]', $project['description']), 'class="form-control" placeholder="Description" htmlEscape="true"'); ?>
                                        </div>
                                    </div> 
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">Miniature</label> <span class="green-text">width : 960px; height: 720px;</span>
                                        <div class="fileupload fileupload-new">
                                            <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                                                <?php if (!empty($project['resource'])) { ?>
                                                    <img src="<?= base_url() . 'assets/uploads/' . $project['resource']['name']; ?>" alt="" />
                                                <?php } else { ?>
                                                    <img src="<?= images_url() . 'no-pic.png'; ?>" alt="" />
                                                <?php } ?>
                                            </div>
                                            <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                                            <div>
                                                <span class="btn btn-white btn-file" style="border-color: rgba(150, 160, 180, 0.3);">
                                                    <span class="fileupload-new thumbnail-load"><i class="fa fa-paper-clip"></i>Charger</span>
                                                    <span class="fileupload-exists thumbnail-change"><i class="fa fa-undo"></i>Changer</span>
                                                </span>
                                                <a class="btn btn-danger fileupload-exists thumbnail-delete" data-dismiss="fileupload"><i class="fa fa-trash"></i> Supprimer</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-right">
                                    <input id="file" name="resource" type="hidden" value="" >
                                    <?= form_submit('submit', 'Modifier', 'class="btn btn-success btn-sm"'); ?>
                                </div>
                            </div>
                        </div>
                </section>
                <?= form_close(); ?>
            </div>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->