<section id="main-content">
    <section class="wrapper">
        <div class="row">
            <div class="col-sm-12">
                <?php if ($this->session->flashdata('flash_msg')) { ?>
                    <?php $alert = $this->session->flashdata('flash_msg'); ?>
                    <div class="alert alert-<?= $alert['type']; ?>" role="alert">
                        <?= $alert['msg']; ?>
                    </div>
                <?php } ?>

                <section class="panel">
                    <header class="panel-heading">
                        Messages
                        <span class="tools pull-right">
                            <a href="javascript:;" class="fa fa-chevron-down"></a>
                        </span>
                    </header>
                    <div class="panel-body">
                        <div class="row">

                            <table class="table table-hover">

                                <thead>
                                <th>#</th>
                                <th>Contact</th>
                                <th>Subject</th>
                                <th>Content</th>
                                <th>Sent</th>
                                <th>Actions</th>
                                </thead>
                                <tbody>
                                    <?php foreach ($messages as $message) { ?>
                                        <tr>
                                            <td>

                                                <?= ($message['is_new'] ? '<strong>' : ''); ?>
                                                <?= $message['id']; ?>
                                                <?= ($message['is_new'] ? '</strong>' : ''); ?>

                                            </td>
                                            <td>
                                                <?= $message['contact']['name']; ?>
                                            </td>

                                            <td>
                                                <?= ($message['is_new'] ? '<strong>' : ''); ?>
                                                <?= $message['subject']; ?>
                                                <?= ($message['is_new'] ? '</strong>' : ''); ?>
                                            </td>
                                            <td>
                                                <?= ($message['is_new'] ? '<strong>' : ''); ?>
                                                <?= $message['content']; ?>
                                                <?= ($message['is_new'] ? '</strong>' : ''); ?>
                                            </td>
                                            <td>
                                                <?= ($message['is_new'] ? '<strong>' : ''); ?>
                                                <?= $message['sent']->format('d-m-Y  H:i:s'); ?>
                                                <?= ($message['is_new'] ? '</strong>' : ''); ?>
                                            </td>
                                            <td>
                                                <a href="<?= site_url('message/' . $message['id'] . '/preview'); ?>" title="Lire" class="btn btn-default btn-sm">
                                                    <i class="fa fa-search"></i>
                                                </a>
                                                <button id="<?= $message['id']; ?>" title="<?= $message['subject']; ?>" class="btn btn-default btn-sm btn-delete">
                                                    <i class="fa fa-trash-o"></i>
                                                </button>
                                            </td>
                                        </tr> 

                                    <?php } ?>
                                    <tr></tr>
                                </tbody>
                            </table>




                        </div>
                    </div>

                </section>
            </div>
        </div>
    </section>
</section>