<!DOCTYPE html>
<html lang="fr">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>F.Seif | <?= $meta['title']; ?></title>
        <meta name="keywords" content="<?= $meta['keywords']; ?>" />
        <meta name="description" content="<?= $meta['description']; ?>">
        <meta name="author" content="<?= $meta['author']; ?>">
        <link rel="shortcut icon" href="<?= images_url(); ?>logo-fer-2.png">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php foreach ($stylesheets as $stylesheet) { ?>
            <link rel="stylesheet" href="<?= $stylesheet; ?>" media="screen"/>
        <?php } ?>
        <link rel="stylesheet" href="<?= css_url(); ?>custom.css" media="screen"/>
    </head>
    <body>
        
        <?= view_loader('online/_header'); ?>
        <?= view_loader('online/_left_pan'); ?>
        <?= $content; ?>
        
        <?php foreach ($javascripts as $javascript) { ?>
            <script type="text/javascript" src="<?= $javascript; ?>"></script>
        <?php } ?>
        <script type="text/javascript">
            $(document).ready(function() {
                var params = {
                    base_url: '<?= base_url(); ?>',
                    images_url: '<?= images_url(); ?>',
                    theme_url: '<?= theme_url(); ?>',
                    wHeight: $(window).height(),
                    programs : {}
                };
                var main= new Main(params);
                main.init();
            <?= $scripts; ?>
            })
        </script>
        <script>
            $('.state-display').click(function() {
                var id = $(this).attr('id');
                $.ajax({
                    url: "<?php echo site_url('galerie/switchDisplay'); ?>" + '/' + id,
                    type: 'POST',
                    dataType: 'json',
                    success: function(output_val) {
                        if (output_val == '1') {
                            $('#' + id).attr('class', 'table-icon true');
                            $('#' + id).attr('title', 'Affiché');
                        } else if (output_val == '0') {
                            $('#' + id).attr('class', 'table-icon false');
                            $('#' + id).attr('title', 'Non Affiché');
                        }
                    }
                });
            });
        </script>
        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
        <script>
              tinymce.init({selector: 'textarea.editablearea',
                  menu: {
                      edit: {title: 'Edit', items: 'undo redo | cut copy paste pastetext | selectall'},
                      insert: {title: 'Insert', items: 'link media | template hr'},
                      table: {title: 'Table', items: 'inserttable tableprops deletetable | cell row column'},
                      tools: {title: 'Tools', items: 'spellchecker code'}
                  },
                  min_height: 170,
                  forced_root_block: false,
                  force_br_newlines: true,
                  force_p_newlines: false
              });
        </script>
        <?= ( in_array('galerie', explode('/', current_url())) ? "<script>
            $('.datepicker').datepicker({
                format: 'dd-mm-yyyy',
                weekStart: 1,
                todayBtn: 'linked',
                clearBtn: true,
                autoclose: true,
                language: 'fr'
            });
        </script>" : ''); ?>
        
    </body>
</html>