<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Socials extends MY_Controller {

    public function liste() {

        $em = $this->doctrine->em;

        $this->local_meta = [
            'title' => 'Sociale',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'socials.js'
        ];
        $this->local_stylesheets = [];
        $this->local_scripts .= 'var socials = new Socials(params);' . chr(13);
        $this->local_scripts .= 'socials.init();' . chr(13);
        $socials = $em->getRepository('Entities\Social')->get();

        $data = [
            'user' => $this->_getUser(),
            'socials' => $socials
        ];
        $content = $this->load->view('socials/socials', $data, TRUE);
        $this->render($content);
    }

    public function add() {
        $em = $this->doctrine->em;
        $this->load->helper('slug_helper');
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->local_meta = [
            'title' => 'Ajouter Réseau',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
        ];
        $this->local_stylesheets = [
        ];

        $this->form_validation->set_rules('socials[name]', 'Name', 'required|trim');
        $this->form_validation->set_rules('socials[link]', 'Link', 'required|trim');
        $this->form_validation->set_rules('socials[class]', 'Class', 'required|trim');
        $this->form_validation->set_rules('socials[pos]', 'Position', 'required|numeric|trim');
        $data = [
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != false) {
            $social = $this->input->post('socials');

            $alert = $em->getRepository('Entities\Social')->addSocial($social);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('socials'), 'get');
        } else {
            $content = $this->load->view('socials/add', $data, true);
            $this->render($content);
        }
    }

    public function update($id) {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper('slug_helper');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Expérience',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_stylesheets = [
        ];
        $this->local_javascripts = [
        ];

        $this->form_validation->set_rules('socials[name]', 'Name', 'required|trim');
        $this->form_validation->set_rules('socials[link]', 'Link', 'required|trim');
        $this->form_validation->set_rules('socials[class]', 'Class', 'required|trim');
        $this->form_validation->set_rules('socials[pos]', 'Position', 'required|numeric|trim');
        
        $entity = $em->getRepository('Entities\Social')->getById($id);
        $data = [
            'user' => $this->_getUser(),
            'socials' => $entity,
        ];
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $socials = $this->input->post('socials');

            $alert = $em->getRepository('Entities\Social')->update($id, $socials);
            $this->session->set_flashdata('flash_msg', $alert);

            redirect(site_url('socials'), "get");
        } else {
            $content = $this->load->view('socials/edit', $data, true);
            $this->render($content);
        }
    }

    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $name = $this->input->post('name');
            $alert = $em->getRepository('Entities\Social')->delete((int) $id, $name);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
