<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Services extends MY_Controller {

    public function liste() {

        $em = $this->doctrine->em;

        $this->local_meta = [
            'title' => 'Service',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'services.js'
        ];
        $this->local_stylesheets = [];
        $this->local_scripts .= 'var services = new Services(params);' . chr(13);
        $this->local_scripts .= 'services.init();' . chr(13);
        $services = $em->getRepository('Entities\Service')->get();

        $data = [
            'user' => $this->_getUser(),
            'services' => $services
        ];
        $content = $this->load->view('services/services', $data, TRUE);
        $this->render($content);
    }

    public function add() {
        $em = $this->doctrine->em;
        $this->load->helper('slug_helper');
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->local_meta = [
            'title' => 'Ajouter Service',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
        ];
        $this->local_stylesheets = [
        ];

        $this->form_validation->set_rules('services[title]', 'Titre', 'required|trim');
        $this->form_validation->set_rules('services[description]', 'Description', 'required|trim');
        $this->form_validation->set_rules('services[class]', 'Class', 'required|trim');
        $this->form_validation->set_rules('services[pos]', 'Position', 'required|numeric|trim');
        $data = [
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != false) {
            $service = $this->input->post('services');

            $alert = $em->getRepository('Entities\Service')->addService($service);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('services'), 'get');
        } else {
            $content = $this->load->view('services/add', $data, true);
            $this->render($content);
        }
    }

    public function update($id) {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper('slug_helper');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Service',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_stylesheets = [
        ];
        $this->local_javascripts = [
        ];

        $this->form_validation->set_rules('services[title]', 'Titre', 'required|trim');
        $this->form_validation->set_rules('services[description]', 'Description', 'required|trim');
        $this->form_validation->set_rules('services[class]', 'Class', 'required|trim');
        $this->form_validation->set_rules('services[pos]', 'Position', 'required|numeric|trim');
        
        $entity = $em->getRepository('Entities\Service')->getById($id);
        $data = [
            'user' => $this->_getUser(),
            'services' => $entity,
        ];
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $socials = $this->input->post('services');

            $alert = $em->getRepository('Entities\Service')->update($id, $socials);
            $this->session->set_flashdata('flash_msg', $alert);

            redirect(site_url('services'), "get");
        } else {
            $content = $this->load->view('services/edit', $data, true);
            $this->render($content);
        }
    }

    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $name = $this->input->post('name');
            $alert = $em->getRepository('Entities\Service')->delete((int) $id, $name);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
