<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Resource extends MY_Controller {

    /**
     * Constructor
     * 
     */
    function __construct() {
        parent::__construct();
    }

    public function index() {
        $this->load->view('upload');
    }

    /**
     * Load the resource load view
     */
    public function loadView($error = null) {
        if ($error) {
            return $this->load->view('resource/form_upload', [
                        'error' => str_replace('_', ' ', $error)
            ]);
        }
        return $this->load->view('resource/form_upload', [
                    'error' => ''
        ]);
    }

    /**
     * Load the resource load view
     */
    public function upload() {
        $this->load->library('upload');

        if ($this->input->post()) {

            if (!$this->upload->do_upload()) {

                $error = [$this->upload->display_errors('', '')];

                echo json_encode([

                    'error' => true,
                    'errorMsg' => str_replace(' ', '_', $error)
                ]);
            } else {

                $data = $this->upload->data();

                $em = $this->doctrine->em;
                $id = $em->getRepository('Entities\Resource')->add($data);

                if ($id) {
                    $data['id'] = $id;

                    echo json_encode([

                        'error' => false,
                        'file' => $data
                    ]);
                } else {

                    unlink($data['full_path']);

                    echo json_encode([

                        'error' => true,
                        'errorMsg' => str_replace(' ', '_', "Ajout de fichier impossible.")
                    ]);
                }
            }
        }
    }

    /**
     * upload for dropzone
     */
    public function upload_dropzone() {
        $this->load->library('upload');
        $this->upload->do_upload('file');
        $data = $this->upload->data();

        $em = $this->doctrine->em;
        $resource = $em->getRepository('Entities\Resource')->add($data);
        if ($resource) {
            $this->output->set_output($resource);
        } else {
            $this->output->set_status_header('404');
        }
    }

    public function delete() {
        $em = $this->doctrine->em;
        $id = $this->input->post('id');
        $resource = $em->getRepository('Entities\Resource')->find($id);
        $album_resource = $em->getRepository('Entities\AlbumResource')->findOneBy(['resource' => $id]);
        if ($album_resource != null) {
            $em->remove($album_resource);
        }
        unlink($resource->getFullPath());
        $em->remove($resource);
        $em->flush();
    }
    
    public function changeFullUrl() {
        $em = $this->doctrine->em;
        $resources = $em->getRepository('Entities\Resource')->findAll();
        
        foreach ($resources as $resource) {
            $new_path = str_replace('strl.tn', 'strl.local', $resource->getFullUrlPath());
            $resource->setFullUrlPath($new_path);
            $em->flush();
        }
    }

}
