<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Projects extends MY_Controller {

    public function main() {
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Projets',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'projects.js'
        ];
        $this->local_stylesheets = [
        ];

        $projects = $em->getRepository('Entities\Project')->get();
        
        $this->local_scripts .= 'var projects= new Projects(params);' . chr(13);
        $this->local_scripts .= 'projects.init();' . chr(13);
        $data = [
            'projects' => $projects,
            'user' => $this->_getUser(),
        ];
        $content = $this->load->view('projects/main', $data, true);
        $this->render($content);
    }

    public function add() {
        $em = $this->doctrine->em;
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->local_meta = [
            'title' => 'Ajouter Projet',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'resource.js',
            js_url() . 'projects.js'
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'resource.css',
        ];
        $this->local_scripts .= 'var projects = new Projects(params);' . chr(13);
        $this->local_scripts .= 'projects.init();' . chr(13);
        
        $this->form_validation->set_rules('project[title]', 'Title', 'trim|required');
        $this->form_validation->set_rules('project[description]', 'Description', 'trim|required');
        $this->form_validation->set_rules('project[position]', 'Position', 'required|numeric|trim');
        $data = [
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != false) {
            $project = $this->input->post('project');
            $active = $this->input->post('active');
            $thumb_id = $this->input->post('resource');
            
            $alert = $em->getRepository('Entities\Project')->add($project, $thumb_id, $active);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('projects'), 'get');
        } else {
            $content = $this->load->view('projects/add', $data, true);
            $this->render($content);
        }
    }

    public function update($id) {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Projet',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'resource.js',
            js_url() . 'projects.js'
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'resource.css',
        ];
        $this->local_scripts .= 'var projects = new Projects(params);' . chr(13);
        $this->local_scripts .= 'projects.init();' . chr(13);

        $this->form_validation->set_rules('project[title]', 'Title', 'trim|required');
        $this->form_validation->set_rules('project[description]', 'Description', 'trim|required');
        $this->form_validation->set_rules('project[position]', 'Position', 'required|numeric|trim');
        
        $project = $em->getRepository('Entities\Project')->getById($id);
        $data = [
            'project' => $project,
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $project = $this->input->post('project');
            $active = $this->input->post('active');
            $thumb_id = $this->input->post('resource');
            
            $alert = $em->getRepository('Entities\Project')->update($id, $project, $active, $thumb_id);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('projects'), 'get');
        } else {
            $content = $this->load->view('projects/edit', $data, true);
            $this->render($content);
        }
    }

    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $title = $this->input->post('title');
            $alert = $em->getRepository('Entities\Project')->delete((int) $id, $title);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
