<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Main extends MY_Controller {

      public function __construct() {
        parent::__construct();
        $user = $this->_getUser();
        if(!$user['admin']) {
            redirect(site_url('flash'));
        }
    }
    
    public function profile() {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Profile',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [];
        $this->local_stylesheets = [];
        $this->local_scripts = '';
        $profile = $em->getRepository('Entities\Profile')->get();
        $data = [
            'error_validation' => FALSE,
            'user' => $this->_getUser(),
            'profile' => $profile
        ];
        $this->form_validation->set_rules('profile[name]', 'Nom');
        $this->form_validation->set_rules('profile[post]', 'Post');
        $this->form_validation->set_rules('profile[description]', 'Presentation', 'required|trim');
        $this->form_validation->set_rules('profile[about]', 'attente', 'trim');
        $this->form_validation->set_rules('profile[address1]', 'address1', 'trim');
        $this->form_validation->set_rules('profile[address2]', 'address2', 'trim');
        $this->form_validation->set_rules('profile[maps]', 'maps', 'trim');
        $this->form_validation->set_rules('profile[tel]', 'Telephone');
        $this->form_validation->set_rules('profile[mobile]', 'Telephone', 'trim');
        $this->form_validation->set_rules('profile[fax]', 'Fax', 'trim');
        $this->form_validation->set_rules('profile[email_contact]', 'Email contact', 'trim|valid_email');
        $this->form_validation->set_rules('profile[email_notification]', 'Email notification', 'trim|valid_email');
        $this->form_validation->set_rules('profile[site_web]', 'Site web', 'trim');

        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $profile = $this->input->post('profile');
            $alert = $em->getRepository('Entities\Profile')->update($profile);
            $this->session->set_flashdata('flash_msg', $alert);

            redirect(site_url('profile'), "get");
        } else {
            $content = $this->load->view('profile/profile', $data, true);
            $this->render($content);
        }
    }

}
