<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Experiences extends MY_Controller {

    public function liste() {

        $em = $this->doctrine->em;

        $this->local_meta = [
            'title' => 'Expérience',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'experiences.js'
        ];
        $this->local_stylesheets = [];
        $this->local_scripts .= 'var experiences = new Experiences(params);' . chr(13);
        $this->local_scripts .= 'experiences.init();' . chr(13);
        $experiences = $em->getRepository('Entities\Experience')->get();

        $data = [
            'user' => $this->_getUser(),
            'experiences' => $experiences
        ];
        $content = $this->load->view('experiences/experiences', $data, TRUE);
        $this->render($content);
    }

    public function add() {
        $em = $this->doctrine->em;
        $this->load->helper('slug_helper');
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->local_meta = [
            'title' => 'Ajouter Expérience',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
        ];
        $this->local_stylesheets = [
        ];

        $this->form_validation->set_rules('experiences[years]', 'Years', 'required|trim');
        $this->form_validation->set_rules('experiences[date]', 'Date', 'required|trim');
        $this->form_validation->set_rules('experiences[place]', 'Place', 'required|trim');
        $this->form_validation->set_rules('experiences[post]', 'Post', 'required|trim');
        $this->form_validation->set_rules('experiences[description]', 'Description', 'required|trim');
        $this->form_validation->set_rules('experiences[position]', 'Position', 'required|numeric|trim');
        $data = [
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != false) {
            $experience = $this->input->post('experiences');

            $alert = $em->getRepository('Entities\Experience')->addExperience($experience);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('experiences'), 'get');
        } else {
            $content = $this->load->view('experiences/add', $data, true);
            $this->render($content);
        }
    }

    public function update($id) {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper('slug_helper');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Expérience',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_stylesheets = [
        ];
        $this->local_javascripts = [
        ];

        $this->form_validation->set_rules('experiences[years]', 'Years', 'required|trim');
        $this->form_validation->set_rules('experiences[date]', 'Date', 'required|trim');
        $this->form_validation->set_rules('experiences[place]', 'Place', 'required|trim');
        $this->form_validation->set_rules('experiences[post]', 'Post', 'required|trim');
        $this->form_validation->set_rules('experiences[description]', 'Description', 'required|trim');
        $this->form_validation->set_rules('experiences[position]', 'Position', 'required|numeric|trim');
        
        $entity = $em->getRepository('Entities\Experience')->getById($id);
        $data = [
            'user' => $this->_getUser(),
            'experiences' => $entity,
        ];
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $experience = $this->input->post('experiences');

            $alert = $em->getRepository('Entities\Experience')->update($id, $experience);
            $this->session->set_flashdata('flash_msg', $alert);

            redirect(site_url('experiences'), "get");
        } else {
            $content = $this->load->view('experiences/edit', $data, true);
            $this->render($content);
        }
    }

    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $name = $this->input->post('name');
            $alert = $em->getRepository('Entities\Experience')->delete((int) $id, $name);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
