<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Contact extends MY_Controller {
    
    public function main() {
    
        $em = $this->doctrine->em;
        
        $this->local_meta=[
          'title'=> 'Contacts',
          'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
          'description' => '',
          'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts=[
            js_url() . 'contact.js'
        ];
        $this->local_stylesheets=[];
        $this->local_scripts .= 'var contact= new Contact(params)' . chr(13);
        $this->local_scripts .= 'contact.init()'. chr(13);
        
        $contacts = $em->getRepository('Entities\Contact')->getAll();
        
        $data = [
            'user' => $this->_getUser(),
            'contacts' =>  $contacts
            ];
            
        $content=  $this->load->view('contact/contact',$data,TRUE);
        $this->render($content);
    }
    
    public function preview($id) {
        $em = $this->doctrine->em;
        $contact = $em->getRepository('Entities\Contact')->get($id);
        $data = [
            'contact' => $contact,
            'user' => $this->_getUser(),
        ];
        echo json_encode([
            'content' => $this->load->view('contact/preview', $data, true)
        ]);
    }
        
        
        public function delete() {
        if($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $name = $this->input->post('name');
            $alert = $em->getRepository('Entities\Contact')->delete((int)$id, $name);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }
}