<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "main/profile";
$route['404_override'] = '';

$route['login']  = "security/login";
$route['logout'] = "security/logout";



$route['profile']          = 'main/profile';


/*educations*/
$route['educations']              = 'educations/liste';
$route['educations/add']          = 'educations/add';
$route['delete-educations']       = 'educations/delete';
$route['educations/(:num)/edit']  = 'educations/update/$1';

/*experiences*/
$route['experiences']              = 'experiences/liste';
$route['experiences/add']          = 'experiences/add';
$route['delete-experiences']       = 'experiences/delete';
$route['experiences/(:num)/edit']  = 'experiences/update/$1';

/*competences*/
$route['competences']              = 'skill/liste';
$route['competences/add']          = 'skill/add';
$route['delete-competences']       = 'skill/delete';
$route['competences/(:num)/edit']  = 'skill/update/$1';

/*sliders*/
$route['sliders']             = 'sliders/main';
$route['sliders/add']         = 'sliders/add';
$route['sliders/(:num)/edit'] = 'sliders/update/$1';
$route['sliders/delete']      = 'sliders/delete';
$route['sliders/changeStatus']= 'sliders/changeStatus';

/*Projects*/
$route['projects']             = 'projects/main';
$route['projects/add']         = 'projects/add';
$route['projects/(:num)/edit'] = 'projects/update/$1';
$route['projects/delete']      = 'projects/delete';
$route['projects/changeStatus']= 'projects/changeStatus';

/*socials*/
$route['socials']              = 'socials/liste';
$route['socials/add']          = 'socials/add';
$route['delete-socials']       = 'socials/delete';
$route['socials/(:num)/edit']  = 'socials/update/$1';

/*Services*/
$route['services']              = 'services/liste';
$route['services/add']          = 'services/add';
$route['delete-services']       = 'services/delete';
$route['services/(:num)/edit']  = 'services/update/$1';

/*picture*/
$route['image']                = 'picture/update';

/*gallery*/
$route['galerie']                = "gallery/main";
$route['galerie/add']            = "gallery/add";
$route['galerie/(:num)/edit']    = "gallery/update/$1";
$route['galerie/switchDisplay/(:num)']    = "gallery/changeDisplay/$1";
$route['galerie/delete']         = "gallery/delete";

/*CV PDF*/
$route['cv-pdf']                = 'cvpdf/update';

/*Messages*/

$route['messages']               = "message/main";
$route['message/(:num)/preview'] = "message/preview/$1";
$route['delete-message']         = "message/delete";


/*Contacts*/

$route['contact']               = "contact/main";
$route['send_message']          = "contact/send_message";
$route['delete-contact']        = "contact/delete";
$route['preview-contact-(:num)']= "contact/preview/$1";

/*Resource upload*/

$route['resource/upload']         = 'resource/upload_dropzone';
$route['resource/delete']         = 'resource/delete';
$route['resource-load']           = 'resource/loadview';
$route['resource-load/(:any)']    = 'resource/loadview/$1';
$route['resource-upload']         = 'resource/upload';


/* End of file routes.php */
/* Location: ./application/config/routes.php */