<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * SocialRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SocialRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('s')
                ->select('s')
                ->orderBy('s.pos', 'ASC');
        $socials = $qb->getQuery()->getArrayResult();
        return $socials;
    }
    
    public function getById($id) {
        $qb = $this->createQueryBuilder('s')
                ->select('s')
                ->where('s.id = :id')
                ->setParameter('id', $id);
        $socials = $qb->getQuery()->getArrayResult();
        return $socials[0];
    }
    
    public function addSocial($social) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le réseau a été ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Social();
            $entity->setName($social['name']);
            $entity->setClass($social['class']);
            $entity->setLink($social['link']);
            $entity->setPos($social['pos']);

            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    public function update($id, $social) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le réseau a été modifiée avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);

            $entity->setName($social['name']);
            $entity->setClass($social['class']);
            $entity->setLink($social['link']);
            $entity->setPos($social['pos']);
            
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    
    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le réseau ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    
    /**
     * Create social
     * 
     * @param array $social
     */
    protected function add($social) {
        $em = $this->getEntityManager();
        $entity = new \Entities\Social();
        
        $entity->setName($social['name']);
        $entity->setLink($social['link']);
        $entity->setClass($social['class']);
        $entity->setPos($social['pos']);

        $em->persist($entity);
        $em->flush();
    }
    
    public function dumpSocial() {
        $socials = [
            [
                'name' => 'Facebook',
                'link'  => 'https://www.facebook.com/Seif.xZx.Ferchichi',
                'class'  => '<i class="fa fa-facebook"></i>',
                'pos'   => 1
            ],
            [
                'name' => 'Tweeter',
                'link'  => '',
                'class'  => '<i class="fa fa-twitter"></i>',
                'pos'   => 2
            ],
            [
                'name' => 'Linkedin',
                'link'  => 'https://www.linkedin.com/in/ferchichi-seifeddine-151b1887',
                'class'  => '<i class="fa fa-linkedin"></i>',
                'pos'   => 3
            ],
            [
                'name' => 'GitHub',
                'link'  => 'https://gitlab.com/u/seif_29',
                'class'  => '<i class="fa fa-github" aria-hidden="true"></i>',
                'pos'   => 4
            ],
            [
                'name' => 'Google Plus',
                'link'  => 'https://plus.google.com/101358954001823190751',
                'class'  => '<i class="fa fa-google-plus"></i>',
                'pos'   => 5
            ],
            [
                'name' => 'Instagram',
                'link'  => 'https://www.instagram.com/ferchichi.seif',
                'class'  => '<i class="fa fa-instagram"></i>',
                'pos'   => 6
            ],
            [
                'name' => 'Youtube',
                'link'  => '',
                'class'  => '<i class="fa fa-youtube"></i>',
                'pos'   => 7
            ],
        ];
        
        foreach($socials as $social) {
            $this->add($social);
        }
    }
}