<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * SliderRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SliderRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('s')
                ->select('s, r')
                ->leftJoin('s.resource', 'r')
                ->orderBy('s.position', 'ASC');
        $slider = $qb->getQuery()->getArrayResult();
        return $slider;
    }
    
    public function getActive() {
        $qb = $this->createQueryBuilder('s')
                ->select('s, r')
                ->leftJoin('s.resource', 'r')
                ->where('s.active = 1')
                ->orderBy('s.position', 'ASC');
        $slider = $qb->getQuery()->getArrayResult();
        return $slider;
    }
    
    public function getById($id) {
        $qb = $this->createQueryBuilder('s')
                ->select('s,res')
                ->leftJoin('s.resource', 'res')
                ->where('s.id = :id')
                ->setParameter('id', $id);
        $sliders = $qb->getQuery()->getArrayResult();
        return $sliders[0];
    }
    
    public function add($slider, $thumb_id, $active) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le Slider est ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Slider();
            $entity->setTitle($slider['title']);
            $entity->setActive($active);
            $entity->setPosition($slider['position']);
            $thumb = $em->getRepository('Entities\Resource')->findOneBy(['id' => $thumb_id]);
            $entity->setResource($thumb);
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    public function update($id, $slider, $active, $thumb_id) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le Slider a été modifié avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);
            $entity->setTitle($slider['title']);
            $entity->setActive($active);
            $entity->setPosition($slider['position']);
            if ($thumb_id != null) {
                $image = $em->getRepository('Entities\Resource')->findOneBy(['id' => $entity->getResource()]);
                $em->remove($image);
                unlink($entity->getResource()->getFullPath());
                $thumb = $em->getRepository('Entities\Resource')->findOneBy(['id' => $thumb_id]);
                $entity->setResource($thumb);
            }
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le slider ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    public function dumpSlider() {
        $em = $this->getEntityManager();
        $sliders = [
            [
                'position' => 1,
                'title' => 'Symfony',
                'resource' => [
                    [
                        'name' => 'symfony_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 2,
                'title' => 'Codeigniter',
                'resource' => [
                    [
                        'name' => 'codeigniter_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 3,
                'title' => 'HTML5 + CSS3',
                'resource' => [
                    [
                        'name' => 'html5_css3_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 4,
                'title' => 'JS',
                'resource' => [
                    [
                        'name' => 'js_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 5,
                'title' => 'Bootstrap',
                'resource' => [
                    [
                        'name' => 'bootstrap_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 6,
                'title' => 'Git',
                'resource' => [
                    [
                        'name' => 'git_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 7,
                'title' => 'AngularJS',
                'resource' => [
                    [
                        'name' => 'angularjs_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 8,
                'title' => 'jQuery',
                'resource' => [
                    [
                        'name' => 'jquery_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 9,
                'title' => 'Composer',
                'resource' => [
                    [
                        'name' => 'composer_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 10,
                'title' => 'JSON',
                'resource' => [
                    [
                        'name' => 'json_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 11,
                'title' => 'XML',
                'resource' => [
                    [
                        'name' => 'xml_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 12,
                'title' => 'MySQL',
                'resource' => [
                    [
                        'name' => 'mysql_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 13,
                'title' => 'Linux',
                'resource' => [
                    [
                        'name' => 'linux_logo.png'
                    ]
                ],
                'active' => true,
            ],
            [
                'position' => 14,
                'title' => 'Ajax',
                'resource' => [
                    [
                        'name' => 'ajax_logo.png'
                    ]
                ],
                'active' => true,
            ]
        ];
        foreach ($sliders as $slider) {
            $entity = new \Entities\Slider();
            $entity->setTitle($slider['title']);
            $entity->setPosition($slider['position']);
            foreach ($slider['resource'] as $thumb) {
                $thumbnail = new \Entities\Resource();
                $thumbnail->setName($thumb['name']);
                $em->persist($thumbnail);
                $entity->setResource($thumbnail);
            }
            $entity->setActive($slider['active']);
            $em->persist($entity);
            $em->flush();
        }
    }
}