<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * SkillRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SkillRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('s')
                ->select('s')
                ->orderBy('s.position', 'ASC');
        $skill = $qb->getQuery()->getArrayResult();
        return $skill;
    }
    
    public function getById($id) {
        $qb = $this->createQueryBuilder('s')
                ->select('s')
                ->where('s.id = :id')
                ->setParameter('id', $id);
        $skills = $qb->getQuery()->getArrayResult();
        return $skills[0];
    }
    
    public function addSkill($skill) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> La compétence a été ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Skill();
            
            $entity->setName($skill['name']);
            $entity->setPercentage($skill['percentage']);
            $entity->setPosition($skill['position']);

            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    public function update($id, $skill) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> La compétence a été modifiée avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);

            $entity->setName($skill['name']);
            $entity->setPercentage($skill['percentage']);
            $entity->setPosition($skill['position']);
            
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    
    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> La compétence ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    protected function add($skill) {
        $em = $this->getEntityManager();
        $entity = new \Entities\Skill();
        
        $entity->setName($skill['name']);
        $entity->setPercentage($skill['percent']);
        $entity->setPosition($skill['position']);

        $em->persist($entity);
        $em->flush();
    }
    
    public function dumpSkill() {

        $skills = [
            [
                'name' => 'PHP5',
                'percent'  => '95',
                'position' => '1'
            ],
            [
                'name' => 'HTML',
                'percent'  => '90',
                'position' => '2'
            ],
            [
                'name' => 'CSS3',
                'percent'  => '70',
                'position' => '3'
            ],
            [
                'name' => 'JS',
                'percent'  => '80',
                'position' => '4'
            ],
            [
                'name' => 'Linux',
                'percent'  => '85',
                'position' => '5'
            ]
           
        ];
        
        foreach($skills as $skill) {
            $this->add($skill);
        }
    }
}