<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * ResourceRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ResourceRepository extends EntityRepository {

    var $name;
    var $mime_type;
    var $path;
    var $full_path;
    var $url_path;
    var $full_url_path;
    var $raw_name;
    var $extension;
    var $is_main;
    var $created_at;
    var $updated_at;

    /**
     * Add resource
     *
     * @param array $resource
     * @return int
     */
    public function add($resource) {
        $em = $this->getEntityManager();
        $thumbnail = new \Entities\Resource();
        $thumbnail->setName($resource['file_name']);
        $thumbnail->setMimeType($resource['file_type']);
        $thumbnail->setPath($resource['file_path']);
        $thumbnail->setFullPath($resource['full_path']);
        $thumbnail->setUrlPath($resource['url_path']);
        $thumbnail->setFullUrlPath(str_replace('https://admin', 'http://www', $resource['full_url_path']));
        $thumbnail->setRawName($resource['raw_name']);
        $thumbnail->setExtension($resource['file_ext']);
        $em->getConnection()->beginTransaction();
        try {
            $em->persist($thumbnail);
            $em->flush();
            $em->getConnection()->commit();
        } catch (Exception $e) {
            $em->getConnection()->rollback();
            $em->close();
            throw $e;
        }
        return $thumbnail->getId();
    }

    /**
     * Delete resource
     *
     * @param int $id
     * @return boolean
     */
    public function remove($id) {
        $em = $this->getEntityManager();
        $resource = $this->find($id);
        $em->remove($resource);
        if ($em->flush()) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

}
