<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * ProfileRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ProfileRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('p')
                ->select('p');
        $profile = $qb->getQuery()->getArrayResult();
        return $profile;
    }

    /**
     * Update the profile
     * 
     * @param array $profile
     * @return array
     */
    public function update($profile) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Modifications effectuées avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $EntityTmp = $em->getRepository('Entities\Profile')->findAll();
            $entity = $EntityTmp[0];
            $entity->setName($profile['name']);
            $entity->setPost($profile['post']);
            $entity->setDescription($profile['description']);
            $entity->setAbout($profile['about']);
            $entity->setAddress1($profile['address1']);
            $entity->setAddress2($profile['address2']);
            $entity->setMaps($profile['maps']);

            $entity->setTel($profile['tel']);
            $entity->setMobile($profile['mobile']);
            $entity->setFax($profile['fax']);
            $entity->setEmailContact($profile['email_contact']);
            $entity->setEmailNotification($profile['email_notification']);
            $entity->setSiteWeb($profile['site_web']);
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommencer plutard.'
            ];
        }
        return $alert;
    }

    public function dumpProfile() {
        $entities = $this->findAll();
        if (count($entities) > 0) {
            return false;
        }
        $em = $this->getEntityManager();
        $profile = [
            [
                'name' => 'Ferchichi Seifeddine',
                'post'  =>  'Freelancer / Développeur Full Stack',
                'description' => "<p>Je suis n&eacute; le 29 ao&ucirc;t 1991 &agrave; Tunis.<br /> Passionn&eacute; par les nouvelles technologies, plus pr&eacute;cis&eacute;ment dans le domaine du web, j'ai pu pas &agrave; pas me forger une exp&eacute;rience sur les probl&eacute;matiques et les enjeux li&eacute;s au Web ainsi qu'aux diff&eacute;rents secteurs d'activit&eacute; connexes.<br /><br />La <strong><u>passion</u></strong> a toujours &eacute;t&eacute; le moteur de ma vie, elle a fait de moi un autodidacte, ma <strong><u>flexibilit&eacute;</u></strong> m'a permis de passer d'un langage &agrave; un autre avec un faible temps d'apprentissage, ma <strong><u>cr&eacute;ativit&eacute;</u></strong> m'a toujours permis d'ajouter une touche sp&eacute;ciale &agrave; mes projets, mon cot&eacute; <strong><u>sociable</u></strong> me permet de travailler aussi bien en &eacute;quipe que seul.</p>",
                'about' => "<p>Je suis n&eacute; le 29 ao&ucirc;t 1991 &agrave; Tunis.<br /> Passionn&eacute; par les nouvelles technologies, plus pr&eacute;cis&eacute;ment dans le domaine du web, j'ai pu pas &agrave; pas me forger une exp&eacute;rience sur les probl&eacute;matiques et les enjeux li&eacute;s au Web ainsi qu'aux diff&eacute;rents secteurs d'activit&eacute; connexes.<br /><br />La <strong><u>passion</u></strong> a toujours &eacute;t&eacute; le moteur de ma vie, elle a fait de moi un autodidacte, ma <strong><u>flexibilit&eacute;</u></strong> m'a permis de passer d'un langage &agrave; un autre avec un faible temps d'apprentissage, ma <strong><u>cr&eacute;ativit&eacute;</u></strong> m'a toujours permis d'ajouter une touche sp&eacute;ciale &agrave; mes projets, mon cot&eacute; <strong><u>sociable</u></strong> me permet de travailler aussi bien en &eacute;quipe que seul.</p>",
                'address1' => 'N°132 Cité Monji Slim, Sidi Thabet Ariana - Tunisie',
                'address2' => 'N°132 Cité Monji Slim, Sidi Thabet Ariana - Tunisie',
                'maps'  => '<iframe id="map-canvas" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d51070.32702698824!2d10.135340269131873!3d36.868921529849096!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x12e2cb4e31471bf3%3A0x65bc5efbce842198!2sAriana%2C+Tunisie!5e0!3m2!1sfr!2s!4v1470395224964" width="600" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>',
                'site_web' => 'www.ferchichi-seifeddine.tn',
                'tel' => '+(216) 20 67 77 97',
                'mobile' => '+(216) 52 15 30 23',
                'fax' => '',
                'email_contact' => 'contact@ferchichi-seifeddine.tn',
                'email_notification' => 'contact@ferchichi-seifeddine.tn',
            ],
            
           
           
        ];
        foreach ($profile as $profile) {
            $entity = new \Entities\Profile();
       
            $entity->setName($profile['name']);
            $entity->setPost($profile['post']);
            $entity->setDescription($profile['description']);
            $entity->setAbout($profile['about']);
            $entity->setAddress1($profile['address1']);
            $entity->setAddress2($profile['address2']);
            $entity->setMaps($profile['maps']);
            $entity->setSiteWeb($profile['site_web']);
            $entity->setTel($profile['tel']);
            $entity->setMobile($profile['mobile']);
            $entity->setFax($profile['fax']);
            $entity->setEmailContact($profile['email_contact']);
            $entity->setEmailNotification($profile['email_notification']);
            $em->persist($entity);
            $em->flush();
        }
    }
}