<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * EducationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class EducationRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('e')
                ->select('e')
                ->orderBy('e.position', 'DESC');
        $education = $qb->getQuery()->getArrayResult();
        return $education;
    }
    
    public function getById($id) {
        $qb = $this->createQueryBuilder('e')
                ->select('e')
                ->where('e.id = :id')
                ->setParameter('id', $id);
        $educations = $qb->getQuery()->getArrayResult();
        return $educations[0];
    }
    
    public function addEducation($education) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> L\'éducation a été ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Education();
            $entity->setYears($education['years']);
            $entity->setPlace($education['place']);
            $entity->setTitle($education['title']);
            $entity->setDescription($education['description']);
            $entity->setPosition($education['position']);

            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    public function update($id, $education) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> L\'éducation a été modifiée avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);

            $entity->setYears($education['years']);
            $entity->setPlace($education['place']);
            $entity->setTitle($education['title']);
            $entity->setDescription($education['description']);
            $entity->setPosition($education['position']);
            
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    
    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> L\'éducation ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    protected function add($education) {
        $em = $this->getEntityManager();
        $entity = new \Entities\Education();
        
        $entity->setYears($education['years']);
        $entity->setPlace($education['place']);
        $entity->setTitle($education['title']);
        $entity->setDescription($education['description']);
        $entity->setPosition($education['position']);

        $em->persist($entity);
        $em->flush();
    }
    
    public function dumpEducation() {

        $educations = [
            [
                'years' => '2009-2010',
                'place' => 'Lycée Sidi Thabet Ariana (Tunisie)',
                'title' => 'Baccalauréat',
                'description' => 'Diplôme de Baccalauréat en Informatique.',
                'position' => '1'
            ],
            [
                'years' => '2010-2014',
                'place' => 'ESTI (Tunisie)',
                'title' => 'Licence',
                'description' => 'Licence Appliquée en informatique à '
                               . 'l\'Ecole Supérieur de Technologie et d’Informatique.<br>'
                               . '- Spécialité : Systèmes informatiques et logiciels.',
                'position' => '2'
            ],
            [
                'years' => '2014-2015',
                'place' => 'ENICarthage (Tunisie)',
                'title' => 'Mastère',
                'description' => 'Mastère professionnel en Ingénierie des Systèmes d\'Information et du Logiciel '
                               . 'à l\'Ecole Nationale d’ingénieurs de Carthage.',
                'position' => '3'
            ]
           
        ];
        
        foreach($educations as $education) {
            $this->add($education);
        }
    }
}