<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Slider
 */
class Slider
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $title
     */
    protected $title;

    /**
     * @var boolean $active
     */
    protected $active;

    /**
     * @var Entities\Resource
     */
    protected $resource;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Slider
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return Slider
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * Get active
     *
     * @return boolean 
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set resource
     *
     * @param Entities\Resource $resource
     * @return Slider
     */
    public function setResource(\Entities\Resource $resource = null)
    {
        $this->resource = $resource;
        return $this;
    }

    /**
     * Get resource
     *
     * @return Entities\Resource 
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * @var integer $position
     */
    protected $position;


    /**
     * Set position
     *
     * @param integer $position
     * @return Slider
     */
    public function setPosition($position)
    {
        $this->position = $position;
        return $this;
    }

    /**
     * Get position
     *
     * @return integer 
     */
    public function getPosition()
    {
        return $this->position;
    }
}