<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Session
 */
class Session
{
    /**
     * @var string $session_id
     */
    protected $session_id;

    /**
     * @var string $ip_address
     */
    protected $ip_address;

    /**
     * @var string $user_agent
     */
    protected $user_agent;

    /**
     * @var integer $last_activity
     */
    protected $last_activity;

    /**
     * @var text $user_data
     */
    protected $user_data;


    /**
     * Set session_id
     *
     * @param string $sessionId
     * @return Session
     */
    public function setSessionId($sessionId)
    {
        $this->session_id = $sessionId;
        return $this;
    }

    /**
     * Get session_id
     *
     * @return string 
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * Set ip_address
     *
     * @param string $ipAddress
     * @return Session
     */
    public function setIpAddress($ipAddress)
    {
        $this->ip_address = $ipAddress;
        return $this;
    }

    /**
     * Get ip_address
     *
     * @return string 
     */
    public function getIpAddress()
    {
        return $this->ip_address;
    }

    /**
     * Set user_agent
     *
     * @param string $userAgent
     * @return Session
     */
    public function setUserAgent($userAgent)
    {
        $this->user_agent = $userAgent;
        return $this;
    }

    /**
     * Get user_agent
     *
     * @return string 
     */
    public function getUserAgent()
    {
        return $this->user_agent;
    }

    /**
     * Set last_activity
     *
     * @param integer $lastActivity
     * @return Session
     */
    public function setLastActivity($lastActivity)
    {
        $this->last_activity = $lastActivity;
        return $this;
    }

    /**
     * Get last_activity
     *
     * @return integer 
     */
    public function getLastActivity()
    {
        return $this->last_activity;
    }

    /**
     * Set user_data
     *
     * @param text $userData
     * @return Session
     */
    public function setUserData($userData)
    {
        $this->user_data = $userData;
        return $this;
    }

    /**
     * Get user_data
     *
     * @return text 
     */
    public function getUserData()
    {
        return $this->user_data;
    }
}