<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Resource
 */
class Resource
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $name
     */
    protected $name;

    /**
     * @var string $mime_type
     */
    protected $mime_type;

    /**
     * @var string $path
     */
    protected $path;

    /**
     * @var string $full_path
     */
    protected $full_path;

    /**
     * @var string $url_path
     */
    protected $url_path;

    /**
     * @var string $full_url_path
     */
    protected $full_url_path;

    /**
     * @var string $raw_name
     */
    protected $raw_name;

    /**
     * @var string $extension
     */
    protected $extension;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Resource
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set mime_type
     *
     * @param string $mimeType
     * @return Resource
     */
    public function setMimeType($mimeType)
    {
        $this->mime_type = $mimeType;
        return $this;
    }

    /**
     * Get mime_type
     *
     * @return string 
     */
    public function getMimeType()
    {
        return $this->mime_type;
    }

    /**
     * Set path
     *
     * @param string $path
     * @return Resource
     */
    public function setPath($path)
    {
        $this->path = $path;
        return $this;
    }

    /**
     * Get path
     *
     * @return string 
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Set full_path
     *
     * @param string $fullPath
     * @return Resource
     */
    public function setFullPath($fullPath)
    {
        $this->full_path = $fullPath;
        return $this;
    }

    /**
     * Get full_path
     *
     * @return string 
     */
    public function getFullPath()
    {
        return $this->full_path;
    }

    /**
     * Set url_path
     *
     * @param string $urlPath
     * @return Resource
     */
    public function setUrlPath($urlPath)
    {
        $this->url_path = $urlPath;
        return $this;
    }

    /**
     * Get url_path
     *
     * @return string 
     */
    public function getUrlPath()
    {
        return $this->url_path;
    }

    /**
     * Set full_url_path
     *
     * @param string $fullUrlPath
     * @return Resource
     */
    public function setFullUrlPath($fullUrlPath)
    {
        $this->full_url_path = $fullUrlPath;
        return $this;
    }

    /**
     * Get full_url_path
     *
     * @return string 
     */
    public function getFullUrlPath()
    {
        return $this->full_url_path;
    }

    /**
     * Set raw_name
     *
     * @param string $rawName
     * @return Resource
     */
    public function setRawName($rawName)
    {
        $this->raw_name = $rawName;
        return $this;
    }

    /**
     * Get raw_name
     *
     * @return string 
     */
    public function getRawName()
    {
        return $this->raw_name;
    }

    /**
     * Set extension
     *
     * @param string $extension
     * @return Resource
     */
    public function setExtension($extension)
    {
        $this->extension = $extension;
        return $this;
    }

    /**
     * Get extension
     *
     * @return string 
     */
    public function getExtension()
    {
        return $this->extension;
    }
}