<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Profile
 */
class Profile
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $name
     */
    protected $name;

    /**
     * @var text $description
     */
    protected $description;

    /**
     * @var text $about
     */
    protected $about;

    /**
     * @var string $address1
     */
    protected $address1;

    /**
     * @var string $address2
     */
    protected $address2;

    /**
     * @var string $site_web
     */
    protected $site_web;

    /**
     * @var string $tel
     */
    protected $tel;

    /**
     * @var string $mobile
     */
    protected $mobile;

    /**
     * @var string $fax
     */
    protected $fax;

    /**
     * @var string $email_contact
     */
    protected $email_contact;

    /**
     * @var string $email_notification
     */
    protected $email_notification;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Profile
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param text $description
     * @return Profile
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * Get description
     *
     * @return text 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set about
     *
     * @param text $about
     * @return Profile
     */
    public function setAbout($about)
    {
        $this->about = $about;
        return $this;
    }

    /**
     * Get about
     *
     * @return text 
     */
    public function getAbout()
    {
        return $this->about;
    }

    /**
     * Set address1
     *
     * @param string $address1
     * @return Profile
     */
    public function setAddress1($address1)
    {
        $this->address1 = $address1;
        return $this;
    }

    /**
     * Get address1
     *
     * @return string 
     */
    public function getAddress1()
    {
        return $this->address1;
    }

    /**
     * Set address2
     *
     * @param string $address2
     * @return Profile
     */
    public function setAddress2($address2)
    {
        $this->address2 = $address2;
        return $this;
    }

    /**
     * Get address2
     *
     * @return string 
     */
    public function getAddress2()
    {
        return $this->address2;
    }

    /**
     * Set site_web
     *
     * @param string $siteWeb
     * @return Profile
     */
    public function setSiteWeb($siteWeb)
    {
        $this->site_web = $siteWeb;
        return $this;
    }

    /**
     * Get site_web
     *
     * @return string 
     */
    public function getSiteWeb()
    {
        return $this->site_web;
    }

    /**
     * Set tel
     *
     * @param string $tel
     * @return Profile
     */
    public function setTel($tel)
    {
        $this->tel = $tel;
        return $this;
    }

    /**
     * Get tel
     *
     * @return string 
     */
    public function getTel()
    {
        return $this->tel;
    }

    /**
     * Set mobile
     *
     * @param string $mobile
     * @return Profile
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;
        return $this;
    }

    /**
     * Get mobile
     *
     * @return string 
     */
    public function getMobile()
    {
        return $this->mobile;
    }

    /**
     * Set fax
     *
     * @param string $fax
     * @return Profile
     */
    public function setFax($fax)
    {
        $this->fax = $fax;
        return $this;
    }

    /**
     * Get fax
     *
     * @return string 
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * Set email_contact
     *
     * @param string $emailContact
     * @return Profile
     */
    public function setEmailContact($emailContact)
    {
        $this->email_contact = $emailContact;
        return $this;
    }

    /**
     * Get email_contact
     *
     * @return string 
     */
    public function getEmailContact()
    {
        return $this->email_contact;
    }

    /**
     * Set email_notification
     *
     * @param string $emailNotification
     * @return Profile
     */
    public function setEmailNotification($emailNotification)
    {
        $this->email_notification = $emailNotification;
        return $this;
    }

    /**
     * Get email_notification
     *
     * @return string 
     */
    public function getEmailNotification()
    {
        return $this->email_notification;
    }
    /**
     * @var string $post
     */
    protected $post;


    /**
     * Set post
     *
     * @param string $post
     * @return Profile
     */
    public function setPost($post)
    {
        $this->post = $post;
        return $this;
    }

    /**
     * Get post
     *
     * @return string 
     */
    public function getPost()
    {
        return $this->post;
    }
    /**
     * @var text $maps
     */
    protected $maps;


    /**
     * Set maps
     *
     * @param text $maps
     * @return Profile
     */
    public function setMaps($maps)
    {
        $this->maps = $maps;
        return $this;
    }

    /**
     * Get maps
     *
     * @return text 
     */
    public function getMaps()
    {
        return $this->maps;
    }
}