<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Message
 */
class Message
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $subject
     */
    protected $subject;

    /**
     * @var string $content
     */
    protected $content;

    /**
     * @var boolean $is_new
     */
    protected $is_new;

    /**
     * @var datetime $sent
     */
    protected $sent;

    /**
     * @var Entities\Contact
     */
    protected $contact;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set subject
     *
     * @param string $subject
     * @return Message
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;
        return $this;
    }

    /**
     * Get subject
     *
     * @return string 
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * Set content
     *
     * @param string $content
     * @return Message
     */
    public function setContent($content)
    {
        $this->content = $content;
        return $this;
    }

    /**
     * Get content
     *
     * @return string 
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Set is_new
     *
     * @param boolean $isNew
     * @return Message
     */
    public function setIsNew($isNew)
    {
        $this->is_new = $isNew;
        return $this;
    }

    /**
     * Get is_new
     *
     * @return boolean 
     */
    public function getIsNew()
    {
        return $this->is_new;
    }

    /**
     * Set sent
     *
     * @param datetime $sent
     * @return Message
     */
    public function setSent($sent)
    {
        $this->sent = $sent;
        return $this;
    }

    /**
     * Get sent
     *
     * @return datetime 
     */
    public function getSent()
    {
        return $this->sent;
    }

    /**
     * Set contact
     *
     * @param Entities\Contact $contact
     * @return Message
     */
    public function setContact(\Entities\Contact $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }

    /**
     * Get contact
     *
     * @return Entities\Contact 
     */
    public function getContact()
    {
        return $this->contact;
    }
}