<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Galerie
 */
class Galerie
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $title
     */
    protected $title;

    /**
     * @var text $description
     */
    protected $description;

    /**
     * @var string $date
     */
    protected $date;

    /**
     * @var string $address
     */
    protected $address;

    /**
     * @var boolean $display
     */
    protected $display;

    /**
     * @var integer $pos
     */
    protected $pos;

    /**
     * @var Entities\Album
     */
    protected $album;

    /**
     * @var Entities\Resource
     */
    protected $image;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Galerie
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set description
     *
     * @param text $description
     * @return Galerie
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * Get description
     *
     * @return text 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set date
     *
     * @param string $date
     * @return Galerie
     */
    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    /**
     * Get date
     *
     * @return string 
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set address
     *
     * @param string $address
     * @return Galerie
     */
    public function setAddress($address)
    {
        $this->address = $address;
        return $this;
    }

    /**
     * Get address
     *
     * @return string 
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Set display
     *
     * @param boolean $display
     * @return Galerie
     */
    public function setDisplay($display)
    {
        $this->display = $display;
        return $this;
    }

    /**
     * Get display
     *
     * @return boolean 
     */
    public function getDisplay()
    {
        return $this->display;
    }

    /**
     * Set pos
     *
     * @param integer $pos
     * @return Galerie
     */
    public function setPos($pos)
    {
        $this->pos = $pos;
        return $this;
    }

    /**
     * Get pos
     *
     * @return integer 
     */
    public function getPos()
    {
        return $this->pos;
    }

    /**
     * Set album
     *
     * @param Entities\Album $album
     * @return Galerie
     */
    public function setAlbum(\Entities\Album $album = null)
    {
        $this->album = $album;
        return $this;
    }

    /**
     * Get album
     *
     * @return Entities\Album 
     */
    public function getAlbum()
    {
        return $this->album;
    }

    /**
     * Set image
     *
     * @param Entities\Resource $image
     * @return Galerie
     */
    public function setImage(\Entities\Resource $image = null)
    {
        $this->image = $image;
        return $this;
    }

    /**
     * Get image
     *
     * @return Entities\Resource 
     */
    public function getImage()
    {
        return $this->image;
    }
}