<?php

class Doctrine {

    // the Doctrine entity manager
    public $em = null;

    public function __construct() {
        // include our CodeIgniter application's database configuration
        // require_once APPPATH.'config/database.php';
        // include Doctrine's fancy ClassLoader class
        require_once MAINPATH . 'vendors/Doctrine/Common/ClassLoader.php';

        // load the Doctrine classes
        $doctrineClassLoader = new \Doctrine\Common\ClassLoader('Doctrine', MAINPATH . 'vendors');
        $doctrineClassLoader->register();

        // load Symfony2 helpers
        // Don't be alarmed, this is necessary for YAML mapping files
        $symfonyClassLoader = new \Doctrine\Common\ClassLoader('Symfony', MAINPATH . 'vendors/Doctrine');
        $symfonyClassLoader->register();

        // load the Gedmo Classes
        $gedmoClassLoader = new \Doctrine\Common\ClassLoader('Gedmo', MAINPATH . 'vendors');
        $gedmoClassLoader->register();

        // load the entities
        $entityClassLoader = new \Doctrine\Common\ClassLoader('Entities', MAINPATH . 'orm');
        $entityClassLoader->register();

        // load the proxy entities
        $proxyClassLoader = new \Doctrine\Common\ClassLoader('Proxies', MAINPATH . 'orm');
        $proxyClassLoader->register();

        // load the reposotory entities
        $repositoryClassLoader = new \Doctrine\Common\ClassLoader('Repositories', MAINPATH . 'orm');

        // set up the configuration 
        $config = new \Doctrine\ORM\Configuration;

        if (ENVIRONMENT == 'development')
        // set up simple array caching for development mode
            $cache = new \Doctrine\Common\Cache\ArrayCache;
        else
        // set up caching with APC for production mode
            $cache = new \Doctrine\Common\Cache\ApcCache;
        $cache->setNamespace(_cache_prefix);
        $config->setMetadataCacheImpl($cache);
        $config->setQueryCacheImpl($cache);

        // set up proxy configuration
        $config->setProxyDir(MAINPATH . 'orm/Proxies');
        $config->setProxyNamespace('Proxies');

        // auto-generate proxy classes if we are in development mode
        $config->setAutoGenerateProxyClasses(ENVIRONMENT == 'development');

        // set up annotation driver
        $yamlDriver = new \Doctrine\ORM\Mapping\Driver\YamlDriver(MAINPATH . 'orm/Mappings');
        $config->setMetadataDriverImpl($yamlDriver);

        $repositoryClassLoader->register();

        // Database connection information
        $connectionOptions = array(
            'driver' => 'pdo_mysql',
            'host' => _dbhost,
            'port' => _dbport,
            'dbname' => _dbname,
            'user' => _dbuser,
            'password' => _dbpass
        );

        // create the EntityManager
        $em = \Doctrine\ORM\EntityManager::create($connectionOptions, $config);

        // Get the EventManager
        $evm = $em->getEventManager();
        // timestampable
        $evm->addEventSubscriber(new \Gedmo\Timestampable\TimestampableListener());
        // sluggable
        $evm->addEventSubscriber(new \Gedmo\Sluggable\SluggableListener());
        // tree
        $evm->addEventSubscriber(new \Gedmo\Tree\TreeListener());

        $evm->addEventSubscriber(
                new \Doctrine\DBAL\Event\Listeners\MysqlSessionInit('utf8', 'utf8_unicode_ci'));
        // store it as a member, for use in our CodeIgniter controllers.
        $this->em = $em;
    }

}
