/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
/* 
 Author     : Proxima
 */

(function($)
{
    $.extend({
        alert: function(parameters) {
            bootbox.dialog({
                message: parameters.msg,
                title: "Ouups!",
                buttons: {
                    dismiss: {
                        label: "Ok",
                        className: "btn-sm btn-primary"
                    }
                }
            });
        },
        serverError: function() {
            bootbox.dialog({
                message: "Une erreur est survenue. Veuillez contacter votre administrateur système. (Code: #500)",
                title: "Ouups!",
                buttons: {
                    dismiss: {
                        label: "Ok",
                        className: "btn-sm btn-primary"
                    }
                }
            });
        },
        confirm: function(parameters, callback) {
            bootbox.dialog({
                message: parameters.msg,
                title: parameters.title,
                buttons: {
                    success: {
                        label: "Oui",
                        className: "btn-sm btn-default",
                        callback: function() {
                            callback(true)
                        }
                    },
                    danger: {
                        label: "Non",
                        className: "btn-sm btn-primary",
                        callback: function() {
                            callback(false)
                        }
                    }
                }
            });
        },
        dialog: function(parameters) {
            bootbox.dialog({
                message: parameters.content,
                title: parameters.title,
                className: parameters.className,
                buttons: parameters.buttons
            });
        },
        hideAll: function() {
            bootbox.hideAll()
        },
        blockPage: function(time) {
            $.blockUI({message: ' '})
        },
        unblockPage: function() {
            $.unblockUI()
        }
    })
})(jQuery);