var Videos = function (parameters) {
    var _params = parameters;
    var obj = {
        page: {
            _reload: function () {
                window.location.href = _params.base_url + 'videos';
            }
        },
        entity: {
            _delete: function (base_url, id) {
                $.confirm({
                    title: "Confirmation de suppression",
                    msg: "Êtes-vous sûr de vouloir supprimer le video \"" + id + "\" ?"
                }, function (response) {
                    if (response === true) {
                        $.ajax({
                            url: base_url + 'delete-videos',
                            type: 'post',
                            data: {
                                id: id
                            },
                            success: function () {
                                obj.page._reload()
                            }
                        });
                    }
                });
            },
            _load_video_content: function (link) {
                var content = '';
                var url = _params.base_url + 'videos/' + link +'/preview';
                $.ajax({
                    url: url,
                    method: 'get',
                    dataType: 'json',
                    async: false,
                    success: function (result) {
                        content = result.content;
                    },
                    beforeSend: function(){
                        $.blockUI()
                    },
                    error: function(){
                        $.unblockUI();
                        $.serverError()
                    }
                });
                return content;
            },            
            _show_video: function (link, title) {
                $.dialog({
                    title: title,
                    className: 'video-preview',
                    content: obj.entity._load_video_content(link),
                    buttons: {
                        stop: {
                            label: 'Arréter',
                            className: 'btn-sm btn-default'
                        }
                    }
                })
            },
            _bind: function () {
                $(document).on("click", ".btn-delete", function () {
                    obj.entity._delete(_params.base_url, $(this).attr('id'))
                })
                $(document).on('click', '.btn-view', function () {
                    obj.entity._show_video($(this).attr('id'), $(this).attr('title'));
                })
            },
            _init: function () {
                obj.entity._bind()
            }
        }
    };
    return {
        /**
         * initializer
         * @returns {undefined}
         */
        init: function () {
            obj.entity._init()
        }
    };
};