/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * author: Proxima
 */

var Resource = function(parameters) {
    var $__s = this,
        $__params = parameters,
        $__thumb = '';
    var obj = {
        page: {
            _show_uploaded: function(base_url, result) {
                var uploadedFile = result.file;
                // need to test on resource type
                var img = '<img class="rsc-img resource" style="max-width: 553px;" id="' + uploadedFile.id + '" src="' + uploadedFile.full_url_path + '" alt="' + uploadedFile.file_name + '">';
                $('.modal-body').html(img);
                $__thumb = img;
            }
        },
        file: {
            _do_upload: function(base_url) {
                var selector = $('.resource-content');
                var progress = $('.progress');
                var bar = $('.bar');
                var percent = $('.percent');
                
                $('#resource-upload-form').ajaxSubmit({
                    data: {
                        file: $(this).serialize(),
                        csrf_token: $.cookie('hts_csrf_cookie_name')
                    },
                    beforeSend: function() {
                        var percentVal = '0%';
                        bar.width(percentVal);
                        percent.html(percentVal);
                    },
                    uploadProgress: function(event, position, total, percentComplete) {
                        selector.css('display', 'none');
                        progress.css('display', 'block');
                        var percentVal = percentComplete + '%';
                        bar.width(percentVal);
                        percent.html(percentVal);
                    },
                    success: function() {
                        var percentVal = '100%';
                        bar.width(percentVal);
                        percent.html(percentVal);
                    },
                    complete: function(result) {
                        var response = JSON.parse(result.responseText);
                        if (!response.error) {
                            var $file_ids = $('#file');
                            $file_ids.val(response.file.id);
                            
                            obj.page._show_uploaded(base_url, response);
                        } else {
                            selector.css('display', 'block');
                            progress.css('display', 'none');
                            obj.form._reload(base_url, response.errorMsg);
                        }
                    }
                });
            }
        },
        form: {
            _bind: function(base_url) {
                $(document).on('click', '#false-resource-input', function() {
                    $('#resource-input').click();
                });
                $(document).on('change', '#resource-input', function() {
                    obj.file._do_upload(base_url);
                });
            },
            _load: function(theme_url, base_url, title, callback) {
                var content = '';
                $.ajax({
                    url: base_url + 'resource-load',
                    method: 'get',
                    dataType: 'html',
                    async: false,
                    success: function(result) {
                        content = result;
                    }
                });
                $.dialog({
                    content: content,
                    title: title,
                    buttons:
                            {
                                submit: {
                                    label: "Sauvegarder",
                                    className: "btn btn-success submit-button",
                                    callback: function() {
                                        $('.thumbnail').html($__thumb);
                                        callback(true);
                                    }
                                },
                                reset: {
                                    label: "Annuler",
                                    className: "btn btn-danger",
                                    callback: function() {
                                        callback(false);
                                    }
                                }
                            }
                });
            },
            _reload: function(base_url, errorMsg) {
                var content = '';
                $.ajax({
                    url: base_url + 'resource-load/' + errorMsg,
                    method: 'get',
                    dataType: 'html',
                    async: false,
                    success: function(result) {
                        content = result;
                    }
                });
                $('.bootbox-body').html(content);
            }
        }
    };
    return {
        /**
         * class global register
         * @param {type} o
         * @returns {Main.Anonym$3}
         */
        register: function(o) {
            $__s.register(o);
            return this;
        },
        /**
         * initializer
         * @returns {undefined}
         */
        load: function(theme_url, base_url, title, callback) {
            obj.form._bind(base_url);
            obj.form._load(theme_url, base_url, title, function(result) {
                if (result) {
                    callback(true);
                } else {
                    callback(false);
                }
            });
        }
    };
};