var Contact = function(parameters) {
    var _params = parameters;
    var obj = {
        page: {
            _reload: function() {
                window.location.href = _params.base_url + 'contact';
            }
        },
        entity: {
            _content_preview: function(id) {
                var content = "";
                $.ajax({
                    url: _params.base_url + "preview-contact-" + id,
                    type: 'get',
                    dataType: 'json',
                    async: false,
                    success: function(response) {
                        content = response.content
                    }
                });
                return content
            },
            _preview: function(id, name) {
                var dialogContent = obj.entity._content_preview(id);
                if (dialogContent != '') {
                    $.dialog({
                        title: "Prévisualisation du contact: " + name,
                        content: dialogContent,
                        buttons: {
                            close: {
                                label: "OK",
                                className: "btn-sm btn-default"
                            }
                        }
                    })
                }
            },
            _delete: function(id, title) {
                $.confirm({
                    title: "Confirmation de suppression",
                    msg: "Êtes-vous sûr de vouloir supprimer le contact \"" + title + "\" ?"
                }, function(response){
                    if(response === true) {
                        $.ajax({
                            url: _params.base_url + 'delete-contact',
                            type: 'post',
                            data: {
                                id: id,
                                title: title
                            },
                            success: function() {
                                obj.page._reload()
                            }
                        });
                    }
                });
            },
            _bind: function() {
                $(document).on("click", ".btn-delete", function() {
                    obj.entity._delete($(this).attr('id'), $(this).attr('title'))
                })
                $(document).on("click", ".btn-preview", function() {
                    obj.entity._preview($(this).attr('id'), $(this).attr('title'))
                })
                $(document).on('click', '.thumbnail-load', function() {
                    
                    var rsc = new Resource();
                    rsc.load(_params.theme_url, _params.base_url, 'Vignette', function(result) {
                        console.log(result);
                    });
                });
                
            },
            _init: function() {
                obj.entity._bind();
            }
        }
    };
    return {
        /**
         * initializer
         * @returns {undefined}
         */
        init: function() {
            obj.entity._init();
        }
    };
};