<!-- Home -->
<section id="home" class="fill">
    <div class="home-background parallax-section">
        <div class="container-fluid">
            <div class="row">
                <div class="home-box col-xs-12">
                    <div>
                        <img src="<?= base_url() . 'assets/uploads/' . $picture['resource']['name']; ?>" alt="Ferchichi Seifeddine : <?= $profile['name'] ?>">
                        <h1><?= $profile['name']; ?></h1>
                        <p><?= $profile['post']; ?></p>
                    </div>
                    <div class="social">
                        <ul>
                            <?php
                            foreach ($socials as $social) {
                                echo '<li><a title="' . $social['name'] . '" href="' . $social['link'] . '" target="_blank">' . $social['class'] . '</a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div><!-- end row -->
        </div><!-- end container -->
    </div>
</section>
<!-- end Home -->

<!-- Education -->
<section id="education">
    <div class="container-fluid">
        <div class="row">
            <div class="section-background col-xs-12 col-sm-6" data-mh="match-edu">
                <h2>Formation</h2>
                <ul class="resume-box">
                    <?php
                    foreach ($educations as $education) {
                        ?>
                        <li>
                            <div class="year" data-mh="match-edu-box-1">
                                <div>
                                    <h4><?= $education['years']; ?></h4>
                                    <span><?= $education['title']; ?></span>
                                </div>
                            </div>
                            <div class="box-content" data-mh="match-edu-box-1">
                                <h4><?= $education['place']; ?></h4>
                                <p><?= nl2br($education['description']); ?></p>
                            </div>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            </div>
            <!-- Skills -->
            <div class="skills-background col-xs-12 col-sm-6" data-mh="match-edu">
                <div class="black-layer">
                    <div class="middle-content">
                        <!-- Skill -->
                        <?php
                        $i = 0;
                        foreach ($skills as $skill) {
                            if ($i % 3 == 0) {
                                echo '<br><br>';
                            }
                            ?>
                            <div class="skill-bar">
                                <input type="text" value="0" data-number="<?= $skill['percentage'] ?>" class="dial">
                                <h4><?= $skill['name'] ?></h4>
                            </div>
                            <?php
                            $i++;
                        }
                        ?>
                        <!-- end Skill -->
                    </div>
                </div>
            </div><!-- end Skills -->
        </div><!-- end row -->
    </div><!-- end container -->
</section>
<!-- end Education -->

<!-- Experience -->
<section id="experience">
    <div class="container-fluid">
        <div class="row">
            <div class="section-background col-xs-12 col-sm-6 col-sm-push-6" data-mh="match-experience">
                <h2>Expérience</h2>
                <ul class="resume-box">
                    <?php
                    foreach ($experiences as $experience) {
                        ?>
                        <li>
                            <div class="year" data-mh="match-exp-box-1">
                                <div>
                                    <h4><?= $experience['years']; ?></h4>
                                    <span><?= $experience['place']; ?></span>
                                </div>
                            </div>
                            <div class="box-content" data-mh="match-exp-box-1">
                                <h4><?= $experience['post']; ?></h4
                                <span><?= $experience['date']; ?></span>
                                <p><?= nl2br($experience['description']); ?></p>
                            </div>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            </div>
            <!-- Hire me -->
            <div class="hire-background col-xs-12 col-sm-6 col-sm-pull-6" data-mh="match-experience">
                <div class="white-layer">
                    <div class="middle-content">
                        <p>Pour consulter la version pdf de mon cv</p>
                        <a href="<?= base_url() . 'assets/uploads/' . $cvpdf['resource']['name']; ?>" target="_blank">Télécharger dès maintenant</a>
                    </div>
                </div>
            </div>
            <!-- end Hire me -->
        </div><!-- end row -->
    </div><!-- end container -->
</section>
<!-- end Experience -->

<!-- Portfolio -->
<section id="portfolio">
    <div class="container-fluid">
        <div class="row">
            <div class="section-background col-xs-12 col-sm-6" data-mh="match-portfolio">
                <h2>à propos</h2>
                <p><?= $profile['description']; ?></p>
            </div>
            <div class="portfolio-content col-xs-12 col-sm-6" data-mh="match-portfolio">
                <div id="portfolioSlider" class="owl-carousel">
                    <!-- projects -->
                    <?php foreach ($projects as $project) { ?>
                        <div>
                            <img src="<?= upload_url() . $project['resource']['name']; ?>" alt="Ferchichi Seifeddine : <?= $project['title'] ?>"><!-- image url -->
                            <div class="image-layer">
                                <div class="image-title">
                                    <h3><?= $project['title'] ?></h3>
                                    <a class="lightbox-popup" href="#popup-<?= $project['id'] ?>">view detail</a>
                                </div>
                            </div>
                            <!-- popup content -->
                            <div id="popup-<?= $project['id'] ?>" class="mfp-hide popup-box">
                                <img src="<?= upload_url() . $project['resource']['name']; ?>" alt="Ferchichi Seifeddine : <?= $project['title'] ?>"><!-- image url -->
                                <div class="popup-content">
                                    <h3><?= $project['title'] ?></h3>
                                    <p><?= $project['description'] ?></p>
                                </div>
                            </div>
                            <!-- end popup content -->
                        </div>
                    <?php } ?>
                    <!-- end projects -->
                </div>
            </div>
        </div><!-- end row -->
    </div><!-- end container -->
</section>
<!-- end Portfolio -->

<!-- Services -->
<section id="services">
    <div class="container-fluid">
        <div class="row">
            <div class="section-background col-xs-12 col-sm-6 col-sm-push-6" data-mh="match-services">
                <h2>Services</h2>
                <!-- Services box -->
                <?php foreach ($services as $service) { ?>
                    <div class="service-box">
                        <div>
                            <?= $service['class'] ?>
                        </div>
                        <div>
                            <h4><?= $service['title'] ?></h4>
                            <p><?= $service['description'] ?></p>
                        </div>
                    </div>
                <?php } ?>
                <!-- End Services box -->
            </div>
            
            
            
            <!-- Facts -->
            <div class="facts-background col-xs-12 col-sm-6 col-sm-pull-6" data-mh="match-services">
                 <div class="white-layer">
                    <div class="middle-content">
                        <div id="clientSlider" class="owl-carousel">
                            <!-- Competence box -->
                            <?php
                            foreach ($sliders as $slider) {
                                ?>
                                <div class="client-box">
                                    <img src="<?= base_url() . 'assets/uploads/' . $slider['resource']['name']; ?>" alt="Ferchichi Seifeddine : <?= $slider['title'] ?>">
                                </div>
                                <?php
                            }
                            ?>
                            <!-- end Competence box -->
                        </div>
                    </div>
                </div>
            </div><!-- end Facts -->
        </div><!-- end row -->
    </div><!-- end container -->
</section>
<!-- end Services -->



<!-- Contact -->
<section id="contact">
    <div class="container-fluid">
        <div class="row">
             <div class="google-maps col-xs-12 col-sm-6 col-sm-push-6" data-mh="match-contact">
                <?= $profile['maps']; ?>
            </div>
            <div class="section-background col-xs-12 col-sm-6 col-sm-pull-6" data-mh="match-contact">
                <h2>Entrer En Contact</h2>
                <ul class="info">
                    <li>
                        <i class="fa fa-map-marker"></i>
                        <span><?= $profile['address1'] ?></span>
                    </li>
                    <li>
                        <i class="fa fa-envelope"></i>
                        <span><?= $profile['email_contact'] ?></span>
                    </li>
                    <li>
                        <i class="fa fa-phone"></i>
                        <span><?= $profile['tel'] ?></span>
                    </li>
                    <li>
                        <i class="fa fa-phone"></i>
                        <span><?= $profile['mobile'] ?></span>
                    </li>
                </ul>
                <?php if ($this->session->flashdata('flash_msg')) { ?>
                    <?php $alert = $this->session->flashdata('flash_msg'); ?>
                    <div class="alert alert-<?= $alert['type']; ?> alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <?= $alert['msg']; ?>
                    </div>
                <?php } ?>
                <?= form_open(site_url('home'), 'class="contact-form" role="form"'); ?>
                <div class="alert-msg">
                    <?php echo validation_errors(); ?>
                    <?php // echo form_error('contact[name]'); ?>
                </div>
                <span>
                    <div class="input-style">
                        <?= form_input('contact[name]', set_value('contact[name]'), 'class="' . (form_error('contact[name]') ? ' formerror' : '') . '" placeholder="Nom et Prénom" '); ?>
                    </div>
                    <div class="input-style">
                        <?= form_input('contact[email]', set_value('contact[email]'), 'class="' . (form_error('contact[email]') ? ' formerror' : '') . '" placeholder="E-Mail" '); ?>
                    </div>
                </span>

                <span>
                    <div class="input-style">
                        <?= form_input('contact[phone]', set_value('contact[phone]'), 'class="' . (form_error('contact[phone]') ? ' formerror' : '') . '" placeholder="Tél" '); ?>
                    </div>
                    <div class="input-style">
                        <?= form_input('message[subject]', set_value('message[subject]'), 'class="' . (form_error('message[subject]') ? ' formerror' : '') . '" placeholder="Sujet" '); ?>
                    </div>
                </span>

                <div class="text-style">
                    <?= form_textarea('message[content]', set_value('message[content]'), 'class="' . (form_error('message[content]') ? ' formerror' : '') . '" placeholder="Message"') ?>
                </div>
                <input type="submit" id="submit" class="submit-style" name="submit" value="Send Message">
                <?= form_close(); ?>
            </div>
           
        </div><!-- end row -->
    </div><!-- end container -->
</section>
<!-- end Contact -->