<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Main extends MY_Controller {

    /**
     * Home Page.
     */
    public function home() {
        $em = $this->doctrine->em;
        $this->local_javascripts = [
            theme_url() . 'js/jquery.min.js',
            'https://maps.googleapis.com/maps/api/js?sensor=true',
            theme_url() . 'js/bootstrap.min.js',
            theme_url() . 'js/jquery.magnific-popup.min.js',
            theme_url() . 'js/retina.min.js',
            theme_url() . 'js/smoothscroll.min.js',
            theme_url() . 'js/theme-plugins.min.js',
            theme_url() . 'js/scripts.min.js',
        ];
        $this->local_stylesheets = [
            theme_url() . 'css/bootstrap.min.css',
            theme_url() . 'css/magnific-popup.min.css',
            theme_url() . 'css/owl.carousel.min.css',
            theme_url() . 'css/owl.theme.min.css',
            theme_url() . 'css/preloader.min.css',
            theme_url() . 'css/theme.min.css',
            theme_url() . 'css/responsive.min.css',
            theme_url() . 'font-awesome/css/font-awesome.min.css',
            theme_url() . 'css/style.css'
        ];


        $profile = $em->getRepository('Entities\Profile')->get();
        $picture = $em->getRepository('Entities\Picture')->get();
        $educations = $em->getRepository('Entities\Education')->get();
        $experiences = $em->getRepository('Entities\Experience')->get();
        $cvpdf = $em->getRepository('Entities\Cvpdf')->get();
        $skills = $em->getRepository('Entities\Skill')->get();
        $sliders = $em->getRepository('Entities\Slider')->getActive();
        $projects = $em->getRepository('Entities\Project')->getActive();
        $socials = $em->getRepository('Entities\Social')->get();
        $services = $em->getRepository('Entities\Service')->get();

        
        $this->local_meta = [
            'title' => 'Ferchichi Seifeddine',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        
        $this->local_data = [
            'GaleriePage' => FALSE,
            'title'         =>  'Accueil',
            'profile'       =>  $profile[0],
            'picture'       =>  $picture,
            'educations'    =>  $educations,
            'experiences'   =>  $experiences,
            'cvpdf'         =>  $cvpdf,
            'skills'        =>  $skills,
            'sliders'       =>  $sliders,
            'projects'      =>  $projects,
            'socials'       =>  $socials,
            'services'      =>  $services
        ];
        
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->form_validation->set_rules('contact[name]', 'Nom', 'required|trim|min_length[3]');
        $this->form_validation->set_rules('contact[email]', 'Email', 'required|trim|valid_email');
        $this->form_validation->set_rules('contact[phone]', 'Tél', 'required|trim');
        $this->form_validation->set_rules('message[subject]', 'Sujet', 'required|trim|min_length[3]');
        $this->form_validation->set_rules('message[content]', 'Message', 'required|trim');
        
        
        if($this->form_validation->run() != FALSE) {
            $contact = $this->input->post('contact');
            $message = $this->input->post('message');
            $alert = $em->getRepository('Entities\Message')->setMessage($contact, $message);
            $this->session->set_flashdata('flash_msg', $alert);
//            $this->mail->send($profile[0]['email_notification']);
            $msg = "Bonjour,\r\n\r\n"
                    . "Vous avez un nouveau message.\r\n"
                    . "Veuillez vous connecter a l'interface d'administration en cliquant sur le lien ci-dessous pour le visualiser.\r\n"
                    . "Lien: http://admin." . _domain . "/\r\n\r\n"
                    . "Webmaster\r\n"
                    . "Ferchichi Seifeddine\r\n\r\n\n-------------- Contenu Du Message --------------\n\n"
                    .  $message['subject']."\n"
                    .  $message['content']."\n\n";
            $headers = "From: " . $contact['email'] . "\r\n";
            $this->load->library('mail');
            $this->mail->send($profile[0]['email_notification'], $msg);
            redirect(site_url('home'), "get");
        } else {
            $content = $this->load->view('main/home', $this->getData(), true);
            $this->render($content);
        }
        
    }
    
    function error_404($msg = NULL) {
        $em = $this->doctrine->em;
        $socials = $em->getRepository('Entities\Social')->get();
        $this->local_javascripts = [
            theme_url() . 'js/jquery.min.js',
            'https://maps.googleapis.com/maps/api/js?sensor=true',
            theme_url() . 'js/bootstrap.min.js',
            theme_url() . 'js/jquery.magnific-popup.min.js',
            theme_url() . 'js/retina.min.js',
            theme_url() . 'js/smoothscroll.min.js',
            theme_url() . 'js/theme-plugins.min.js',
            theme_url() . 'js/scripts.min.js',
        ];
        $this->local_stylesheets = [
            theme_url() . 'css/bootstrap.min.css',
            theme_url() . 'css/magnific-popup.min.css',
            theme_url() . 'css/owl.carousel.min.css',
            theme_url() . 'css/owl.theme.min.css',
            theme_url() . 'css/preloader.min.css',
            theme_url() . 'css/theme.min.css',
            theme_url() . 'css/responsive.min.css',
            theme_url() . 'font-awesome/css/font-awesome.min.css',
            theme_url() . 'css/style.css'
        ];
        
        $this->local_meta = [
            'title' => 'Ferchichi Seifeddine',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        
        $this->local_data = [
            'GaleriePage' => FALSE,
            'socials'       =>  $socials,
            'title'       =>  'Page Not Found',
            'message' => ($msg) ? $msg : "La page que vous avez demandée n'a pas été trouvée !",
        ];
        $this->render($this->load->view('error/error_404', $this->getData(), true));
    }
}
