<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Galerie extends MY_Controller {

    /**
     * Home Page.
     */
    public function main() {
        $em = $this->doctrine->em;
        $socials = $em->getRepository('Entities\Social')->get();
        $gallery = $em->getRepository('Entities\Galerie')->getFront();

        $this->local_javascripts = [
            js_url() . 'jquery.min.js',
            js_url() . 'bootstrap.min.js',
            js_url() . 'responsiveslides.min.js',
            js_url() . 'modernizr.custom.97074.js',
            js_url() . 'jquery.chocolat.js',
            js_url() . 'move-top.js',
            js_url() . 'easing.js',
            js_url() . 'script.js',
            'https://maps.googleapis.com/maps/api/js?sensor=true',
            theme_url() . 'js/jquery.magnific-popup.min.js',
            theme_url() . 'js/theme-plugins.min.js',
            theme_url() . 'js/scripts.min.js',
        ];
        $this->local_stylesheets = [
            css_url() . 'bootstrap.min.css',
            css_url() . 'style.css',
            theme_url() . 'css/responsive.min.css',
            theme_url() . 'font-awesome/css/font-awesome.min.css',
            css_url() . 'album/main.css',
            css_url() . 'album/style.css',
            'https://fonts.googleapis.com/css?family=Montserrat:400,700',
            'https://fonts.googleapis.com/css?family=Crimson+Text:400,400italic,600,600italic,700,700italic',
            theme_url() . 'css/theme.min.css',
            theme_url() . 'css/responsive.min.css',
        ];

        $months = array("", "JAN", "FÉV", "MAR", "AVR", "MAI", "JUIN",
            "JUIL", "AOÛ", "SEP", "OCT", "NOV", "DÉC");

        $this->local_meta = [
            'title' => 'Ferchichi Seifeddine',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];

        $this->local_data = [
            'GaleriePage' => TRUE,
            'title' => 'Galerie',
            'socials' => $socials,
            'gallery' => $gallery,
            'months' => $months
        ];

        $this->load->helper('text');
        $content = $this->load->view('galerie/main', $this->getData(), true);
        $this->render($content);
    }

    /**
     * Home Page.
     */
    public function album($id, $title) {
        $em = $this->doctrine->em;
        $socials = $em->getRepository('Entities\Social')->get();
        $galerie = $em->getRepository('Entities\Galerie')->getById($id);
        if (!$galerie) {
            redirect(site_url('404_override'), 'get');
        }
        if (urldecode($title) != $galerie[0]['title']) {
            redirect(site_url('404_override'), 'get');
        }
        
        $this->local_javascripts = [
            js_url() . 'jquery.min.js',
            js_url() . 'bootstrap.min.js',
            js_url() . 'responsiveslides.min.js',
            js_url() . 'modernizr.custom.97074.js',
            js_url() . 'jquery.chocolat.js',
            js_url() . 'move-top.js',
            js_url() . 'easing.js',
            'https://maps.googleapis.com/maps/api/js?sensor=true',
            theme_url() . 'js/jquery.magnific-popup.min.js',
            theme_url() . 'js/theme-plugins.min.js',
            theme_url() . 'js/scripts.min.js',
        ];
        $this->local_stylesheets = [
            css_url() . 'bootstrap.min.css',
            css_url() . 'style.css',
            css_url() . 'flexslider.css',
            css_url() . 'chocolat.css',
            theme_url() . 'css/theme.min.css',
            theme_url() . 'css/responsive.min.css',
            theme_url() . 'font-awesome/css/font-awesome.min.css',
            'http://fonts.googleapis.com/css?family=Sigmar+One',
            'http://fonts.googleapis.com/css?family=Raleway:400,500,600',
            theme_url() . 'css/theme.min.css',
            theme_url() . 'css/responsive.min.css',
            css_url() . 'stylealbum.css',
        ];

        $this->local_meta = [
            'title' => 'Ferchichi Seifeddine',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];

        $this->local_data = [
            'GaleriePage' => TRUE,
            'title' => 'Galerie',
            'socials' => $socials,
            'galerie' => $galerie[0]
        ];
        
        $this->load->helper('text');
        $content = $this->load->view('galerie/album', $this->getData(), true);
        $this->render($content);
    }

}
