<!--main content start-->
<section id="main-content">
    <section class="wrapper">
        <div class="row">
            <div class="col-sm-12">
                <?php if ($this->session->flashdata('flash_msg')) { ?>
                    <?php $alert = $this->session->flashdata('flash_msg'); ?>
                    <div class="alert alert-<?= $alert['type']; ?> alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Fermer</span></button>
                        <?= $alert['msg']; ?>
                    </div>
                <?php } ?>
                <section class="panel panel-tools">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-leftt">
                                <a href="<?= site_url('galerie/add'); ?>" class="btn btn-success btn-sm">Ajouter un Album</a>
                            </div>
                        </div>
                    </div>
                </section>
                <section class="panel">
                    <header class="panel-heading">
                        Galleries
                        <span class="tools pull-right">
                            <a href="javascript:;" class="fa fa-chevron-down"></a>
                        </span>
                    </header>
                    <div class="panel-body">
                        <table class="table  table-hover general-table">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 20px">#</th>
                                    <th class="text-center" style="width: 60px">Image</th>
                                    <th>Titre</th>
                                    <th>Adresse</th>
                                    <th>Date</th>
                                    <th class="text-center" style="width: 100px">Statut</th>
                                    <th class="text-center" style="width: 100px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($galeries as $gallery) { ?>
                                    <tr>
                                        <td class="text-center"><?= $gallery['pos']; ?></td>
                                        <td class="text-center">
                                            <?php if ($gallery['image']['name']) { ?>
                                                <img src="<?= base_url() . 'assets/uploads/' . $gallery['image']['name']; ?>" alt="" style="width: 100px; " />
                                            <?php } else { ?>
                                                <img src="<?= images_url() . 'no-pic.png'; ?>" alt="" style="width: 100px;"  />
                                            <?php } ?>
                                        </td>
                                        <td><?= $gallery['title']; ?></td>
                                        <td><?= $gallery['address']; ?></td>
                                        <td><?= $gallery['date']; ?></td>
                                        <td class="text-center">
                                            <a href="#" id="<?= $gallery['id']; ?>" class="table-icon <?php if ($gallery['display']) { ?> state-display true <?php } else { ?> state-display false <?php } ?>" title="<?php if ($gallery['display']) { ?> Affiché <?php } else { ?> Non Affiché <?php } ?>"></a>                                            
                                        </td>
                                        <td class="text-center">
                                            <a href="<?= site_url('galerie/' . $gallery['id'] . '/edit'); ?>" class="btn btn-default btn-sm">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <button id="<?= $gallery['id']; ?>" title="<?= $gallery['title']; ?>" class="btn btn-default btn-sm btn-delete">
                                                <i class="fa fa-trash-o"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->