<section id="main-content">
    <section class="wrapper">
        <div class="msg">
            <?php if ($this->session->flashdata('flash_msg')) { ?>
                <?php $alert = $this->session->flashdata('flash_msg'); ?>
                <div class="alert alert-<?= $alert['type']; ?> alert-dismissible" role="alert">
                    <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                    <?= $alert['msg']; ?>
                </div>
            <?php } ?>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <section class="panel panel-tools">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-leftt">
                                <a href="<?= site_url('educations/add'); ?>" class="btn btn-success btn-sm">Ajouter une éducation</a>
                            </div>
                        </div>
                    </div>
                </section>
                <section class="panel">
                    <header class="panel-heading">
                        Éducations
                        <span class="tools pull-right">
                            <a href="javascript:;" class="fa fa-chevron-down"></a>
                        </span>
                    </header>
                    <div class="panel-body">
                        <div class="row">
                            <table class="table table-hover">
                                <thead>
                                <th style="width:2%; text-align: center;">Position</th>
                                <th style="width:10%;">Années</th>
                                <th style="width:20%;">Place</th>
                                <th style="width:30%;">Titre</th>
                                <th style="width:30%;">Description</th>
                                <th style="width:8%; text-align: center;">Action</th>
                                </thead>
                                <tbody>
                                    <?php foreach ($educations as $education) { ?>
                                        <tr id="<?= $education['id']; ?>" >
                                            <td style="text-align: center">
                                                <?= $education['position']; ?>
                                            </td>
                                            <td>
                                                  <?= $education['years']; ?>
                                            </td> 
                                            <td>
                                                  <?= $education['place']; ?>
                                            </td> 
                                            <td>
                                                  <?= $education['title']; ?>
                                            </td> 
                                            <td>
                                                  <?= $education['description']; ?>
                                            </td> 
                                            
                                            <td style="text-align: center">
                                                <a href="<?= site_url('educations/' . $education['id'].'/edit'); ?>" title="Modifier" class="btn btn-default btn-xs">
                                                    <i class="fa fa-edit"></i>
                                                </a>
                                                <button id="<?= $education['id']; ?>" title="<?= $education['title']; ?>" class="btn btn-default btn-sm btn-delete">
                                                    <i class="fa fa-trash-o"></i>
                                                </button>
                                            </td>
                                        </tr> 
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>