<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class MY_Controller extends CI_Controller {

    protected $layout = 'base';
    protected $meta = [];
    protected $stylesheets = [];
    protected $javascripts = [];
    protected $scripts = '';
    protected $local_meta = [];
    protected $local_stylesheets = [];
    protected $local_javascripts = [];
    protected $local_scripts = '';

    /**
     * Construct
     */
    public function __construct() {
        parent::__construct();
        $this->load->helper('ssl_helper');
        force_ssl();
        $this->load->library('session');
        if (!$this->session->userdata('logged_in')) {
            redirect(site_url('login'), 'get');
        }
        $this->meta = [];
        $this->stylesheets = [
            common_path() . 'bootstrap/css/bootstrap.min.css',
            common_path() . 'bootstrap/css/bootstrap-theme.min.css',
            common_path() . 'font-awesome/css/font-awesome.css',
            common_path() . 'bootbox/css/bootbox.css',
            common_path() . 'blockUI/css/blockUI.css',
            css_url() . 'custom.css',
            theme_url() . 'bs3/css/bootstrap.min.css',
            theme_url() . 'css/style.css',
            theme_url() . 'css/style-responsive.css',
        ];
        $this->javascripts = [
            common_url() . 'jquery/jquery-2.1.1.min.js',
            common_url() . 'jquery/jquery-migrate-1.2.1.min.js',
            common_url() . 'jquery/jquery.easing.js',
            common_url() . 'jquery/jquery.cookie.js',
            common_url() . 'jqueryForm/jquery.form.min.js',
            common_url() . 'bootstrap/js/bootstrap.min.js',
            common_url() . 'bootbox/js/bootbox.min.js',
            common_url() . 'blockUI/js/jquery.blockUI.min.js',
            common_url() . 'proxima/js/jquery.proxima.plugins.js',
            theme_url() . 'js/accordion-menu/jquery.dcjqaccordion.2.7.js',
            theme_url() . 'js/scrollTo/jquery.scrollTo.min.js',
            theme_url() . 'js/nicescroll/jquery.nicescroll.js',
            theme_url() . 'js/accordion-menu/jquery.dcjqaccordion.2.7.js',
            theme_url() . 'assets/easypiechart/jquery.easypiechart.js',
            theme_url() . 'assets/sparkline/jquery.sparkline.js',
            theme_url() . 'assets/flot-chart/jquery.flot.js',
            theme_url() . 'assets/easypiechart/jquery.easypiechart.js',
            theme_url() . 'assets/flot-chart/jquery.flot.tooltip.min.js',
            theme_url() . 'assets/flot-chart/jquery.flot.resize.js',
            theme_url() . 'assets/flot-chart/jquery.flot.pie.resize.js',
            theme_url() . 'js/scripts.js',
            js_url() . 'main.js',
        ];
    }

    /*
     * Render a view into the base template
     * 
     * @param string $content
     */

    protected function render($content) {
        $view_data = array(
            'meta' => $this->get_meta(),
            'content' => $content,
            'stylesheets' => $this->get_stylesheets(),
            'javascripts' => $this->get_javascripts(),
            'scripts' => $this->get_scripts()
        );
        $this->load->view($this->layout, $view_data);
    }

    /**
     * Get view data
     * 
     * @return array
     */
    public function getData() {
        return array_merge($this->data, $this->local_data);
    }

    /**
     * Get Metas tag
     * 
     * @return array
     */
    protected function get_meta() {
        return array_merge($this->meta, $this->local_meta);
    }

    /**
     * Get stylesheets
     * 
     * @return array
     */
    protected function get_stylesheets() {
        return array_merge($this->stylesheets, $this->local_stylesheets);
    }

    /**
     * Get js plugins
     * 
     * @return array
     */
    protected function get_javascripts() {
        return array_merge($this->javascripts, $this->local_javascripts);
    }

    /**
     * Get scripts
     * 
     * @return string
     */
    protected function get_scripts() {
        return $this->scripts . chr(13) . $this->local_scripts;
    }

    public function _getUser() {
        return $this->session->userdata('logged_in');
    }

    /**
     * Get comment views data
     * 
     * @return array
     */
    protected function getCommonViewData() {
        return [
            'profile' => $this->getProfile(),
            'membres' => $this->getMembres(),
            'advertising' => $this->getAdvertising(),
            'gallery_right' => $this->getGalleryRight(),
        ];
    }

    /**
     * Get Syndicat
     * 
     * @return array
     */
    protected function getProfile() {
        $em = $this->doctrine->em;
        $profile = $em->getRepository('Entities\Profile')->get();

        return $profile;
    }

}
