<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sliders extends MY_Controller {

    public function main() {
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Sliders',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'sliders.js'
        ];
        $this->local_stylesheets = [
        ];

        $sliders = $em->getRepository('Entities\Slider')->get();
        
        $this->local_scripts .= 'var sliders= new Sliders(params);' . chr(13);
        $this->local_scripts .= 'sliders.init();' . chr(13);
        $data = [
            'sliders' => $sliders,
            'user' => $this->_getUser(),
        ];
        $content = $this->load->view('sliders/main', $data, true);
        $this->render($content);
    }

    public function add() {
        $em = $this->doctrine->em;
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->local_meta = [
            'title' => 'Ajouter Slider',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'resource.js',
            js_url() . 'sliders.js'
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'resource.css',
        ];
        $this->local_scripts .= 'var sliders = new Sliders(params);' . chr(13);
        $this->local_scripts .= 'sliders.init();' . chr(13);
        
        $this->form_validation->set_rules('sliders[title]', 'Title', 'trim|required');
        $this->form_validation->set_rules('sliders[position]', 'Position', 'required|numeric|trim');
        $data = [
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != false) {
            $slider = $this->input->post('sliders');
            $active = $this->input->post('active');
            $thumb_id = $this->input->post('resource');
            
            $alert = $em->getRepository('Entities\Slider')->add($slider, $thumb_id, $active);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('sliders'), 'get');
        } else {
            $content = $this->load->view('sliders/add', $data, true);
            $this->render($content);
        }
    }

    public function update($id) {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Slider',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'resource.js',
            js_url() . 'sliders.js'
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'resource.css',
        ];
        $this->local_scripts .= 'var sliders = new Sliders(params);' . chr(13);
        $this->local_scripts .= 'sliders.init();' . chr(13);

        $this->form_validation->set_rules('sliders[title]', 'Title', 'trim|required');
        $this->form_validation->set_rules('sliders[position]', 'Position', 'required|numeric|trim');
        
        $slider = $em->getRepository('Entities\Slider')->getById($id);
        $data = [
            'sliders' => $slider,
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $sliders = $this->input->post('sliders');
            $active = $this->input->post('active');
            $thumb_id = $this->input->post('resource');
            
            $alert = $em->getRepository('Entities\Slider')->update($id, $sliders, $active, $thumb_id);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('sliders'), 'get');
        } else {
            $content = $this->load->view('sliders/edit', $data, true);
            $this->render($content);
        }
    }

    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $title = $this->input->post('title');
            $alert = $em->getRepository('Entities\Slider')->delete((int) $id, $title);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
