<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Skill extends MY_Controller {

    public function liste() {

        $em = $this->doctrine->em;

        $this->local_meta = [
            'title' => 'Compétence',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'skill.js'
        ];
        $this->local_stylesheets = [];
        $this->local_scripts .= 'var skill = new Skill(params);' . chr(13);
        $this->local_scripts .= 'skill.init();' . chr(13);
        $competences = $em->getRepository('Entities\Skill')->get();

        $data = [
            'user' => $this->_getUser(),
            'competences' => $competences
        ];
        $content = $this->load->view('skill/skill', $data, TRUE);
        $this->render($content);
    }

    public function add() {
        $em = $this->doctrine->em;
        $this->load->helper('slug_helper');
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->local_meta = [
            'title' => 'Ajouter Compétence',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
        ];
        $this->local_stylesheets = [
        ];

        $this->form_validation->set_rules('skill[name]', 'Name', 'required|trim');
        $this->form_validation->set_rules('skill[percentage]', 'Percentage', 'required|numeric|trim');
        $this->form_validation->set_rules('skill[position]', 'Position', 'required|numeric|trim');
        $data = [
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != false) {
            $skill = $this->input->post('skill');

            $alert = $em->getRepository('Entities\Skill')->addSkill($skill);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('competences'), 'get');
        } else {
            $content = $this->load->view('skill/add', $data, true);
            $this->render($content);
        }
    }

    public function update($id) {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper('slug_helper');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Compétence',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_stylesheets = [
        ];
        $this->local_javascripts = [
        ];

        $this->form_validation->set_rules('skill[name]', 'Name', 'required|trim');
        $this->form_validation->set_rules('skill[percentage]', 'Percentage', 'required|numeric|trim');
        $this->form_validation->set_rules('skill[position]', 'Position', 'required|numeric|trim');
        
        $entity = $em->getRepository('Entities\Skill')->getById($id);
        $data = [
            'user' => $this->_getUser(),
            'competences' => $entity,
        ];
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $skill = $this->input->post('skill');

            $alert = $em->getRepository('Entities\Skill')->update($id, $skill);
            $this->session->set_flashdata('flash_msg', $alert);

            redirect(site_url('competences'), "get");
        } else {
            $content = $this->load->view('skill/edit', $data, true);
            $this->render($content);
        }
    }

    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $name = $this->input->post('name');
            $alert = $em->getRepository('Entities\Skill')->delete((int) $id, $name);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
