<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Picture extends MY_Controller {

    public function update() {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier L\'image',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'resource.js',
            js_url() . 'picture.js'
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'resource.css',
        ];
        $this->local_scripts .= 'var picture = new Picture(params);' . chr(13);
        $this->local_scripts .= 'picture.init();' . chr(13);
        
        $picture = $em->getRepository('Entities\Picture')->get();
        $data = [
            'picture' => $picture,
            'user' => $this->_getUser(),
        ];
        
        $this->form_validation->set_rules('resource', 'Resource', 'required');
        
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $thumb_id = $this->input->post('resource');
            
            $alert = $em->getRepository('Entities\Picture')->update($thumb_id);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('image'), 'get');
        } else {
            $content = $this->load->view('picture/edit', $data, true);
            $this->render($content);
        }
    }
   
}
