<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Message extends MY_Controller {

    public function main() {

        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Profile',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'message.js'
        ];
        $this->local_stylesheets = [];
        $this->local_scripts .= 'var message= new Message(params)' . chr(13);
        $this->local_scripts .= 'message.init();' . chr(13);
        $messages = $em->getRepository('Entities\Message')->getAll();
        $data = [
            'user' => $this->_getUser(),
            'messages' => $messages
        ];

        $content = $this->load->view('message/message', $data, TRUE);
        $this->render($content);
    }

    public function preview($id) {
        $em = $this->doctrine->em;
        $message = $em->getRepository('Entities\Message')->get($id);
        $this->local_meta = [
            'title' => $message['subject'],
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];

        $this->local_javascripts = [];
        $this->local_stylesheets = [
            css_url() . 'message.css'
        ];
        $this->local_scripts = '';
        $data = [
            'user' => $this->_getUser(),
            'message' => $message
        ];
        $content = $this->load->view('message/preview', $data, true);
        $this->render($content);
    }

    public function delete() {

        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $subject = $this->input->post('subject');
            $alert = $em->getRepository('Entities\Message')->delete((int) $id, $subject);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
