<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gallery extends MY_Controller {

    /**
     * Page Main Gallery
     * 
     */
    public function main() {
        $em = $this->doctrine->em;
        $galeries = $em->getRepository('Entities\Galerie')->get();
        $this->local_meta = [
            'title' => 'Galerie',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'galerie.js'
        ];
        $this->local_stylesheets = [];
        $this->local_scripts .= 'var galerie = new Galerie(params);' . chr(13);
        $this->local_scripts .= 'galerie.init();' . chr(13);
        $data = [
            'user' => $this->_getUser(),
            'galeries' => $galeries
        ];
        $content = $this->load->view('galerie/main', $data, true);
        $this->render($content);
    }

    /**
     * Page New Gallery
     * 
     */
    public function add() {
        $em = $this->doctrine->em;
        $this->load->library('form_validation');
        $this->load->helper('form');
        $this->local_meta = [
            'title' => 'Galerie',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'dropzone.min.js',
            js_url() . 'dropzone_resource.js',
            js_url() . 'resource.js',
            js_url() . 'galerie.js',
            js_url() . 'bootstrap-datepicker/js/bootstrap-datepicker.min.js',
            js_url() . 'bootstrap-datepicker/locales/bootstrap-datepicker.fr.min.js',
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'dropzone.css',
            css_url() . 'resource.css',
            css_url() . 'bootstrap-datepicker3.min.css'
        ];
        $this->local_scripts = 'var dr = new Dropzone_resource(params);' . chr(13);
        $this->local_scripts .= 'dr.add();' . chr(13);
        $this->local_scripts .= 'var galerie = new Galerie(params);' . chr(13);
        $this->local_scripts .= 'galerie.init();' . chr(13);


        $data = [
            'user' => $this->_getUser(),
        ];
        
        $this->form_validation->set_rules('galerie[title]', 'Titre', 'trim|required');
        $this->form_validation->set_rules('galerie[date]', 'Date', 'trim|required');
        $this->form_validation->set_rules('galerie[address]', 'Address', 'trim|required');
        $this->form_validation->set_rules('galerie[description]', 'Description', 'trim|required');
        $this->form_validation->set_rules('galerie[display]', 'Display|required');
        $this->form_validation->set_rules('galerie[pos]', 'Index', 'trim|required');
        
        
        if ($this->form_validation->run() != FALSE) {
            $galerie = $this->input->post('galerie');
            $files = explode(',', $this->input->post('files'));
            $thumb_id = $this->input->post('resource');
            $alert = $em->getRepository('Entities\Galerie')->add($galerie, $files, $thumb_id);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('galerie'), "get");
        } else {
            $content = $this->load->view('galerie/add', $data, true);
            $this->render($content);
        }
    }

    /**
     * Update Gallery
     * 
     */
    public function update($id) {
        $em = $this->doctrine->em;
        $entity = $em->getRepository('Entities\Galerie')->getById($id)[0];

        $this->load->library('form_validation');
        $this->load->helper('form');
        $this->local_meta = [
            'title' => 'Modifier Album',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'dropzone.min.js',
            js_url() . 'dropzone_resource.js',
            js_url() . 'resource.js',
            js_url() . 'galerie.js',
            js_url() . 'bootstrap-datepicker/js/bootstrap-datepicker.min.js',
            js_url() . 'bootstrap-datepicker/locales/bootstrap-datepicker.fr.min.js',
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'dropzone.css',
            css_url() . 'resource.css',
            css_url() . 'bootstrap-datepicker3.min.css'
        ];
        $this->local_scripts = 'var dr = new Dropzone_resource(params);' . chr(13);
        $this->local_scripts .= 'var galerie = new Galerie(params);' . chr(13);
        $this->local_scripts .= 'galerie.init();' . chr(13);
        $exsiting_domains = [];
        $images = [];
        $thumb = null;


        foreach ($entity['album']['album_resources'] as $albumResource) {
            $images [] = $albumResource['resource'];
        }
        $this->local_scripts .= 'dr.update("' . base_url() . '", "' . upload_url() . '",  ' . json_encode($images) . ');' . chr(13);

        $data = [
            'user' => $this->_getUser(),
            'exsiting_domains' => $exsiting_domains,
            'thumb' => $thumb,
            'images' => $images,
            'galerie' => $entity
        ];

        $this->form_validation->set_rules('galerie[title]', 'Titre', 'trim|required');
        $this->form_validation->set_rules('galerie[date]', 'Date', 'trim|required');
        $this->form_validation->set_rules('galerie[address]', 'Address', 'trim|required');
        $this->form_validation->set_rules('galerie[description]', 'Description', 'trim|required');
        $this->form_validation->set_rules('galerie[display]', 'Display|required');
        $this->form_validation->set_rules('galerie[pos]', 'Index', 'trim|required');
        
        if ($this->form_validation->run() != FALSE) {
            $galerie = $this->input->post('galerie');
            $files = $this->input->post('files');
            $thumb_id = $this->input->post('resource');

            $alert = $em->getRepository('Entities\Galerie')->update($id, $galerie, explode(',', $files), $thumb_id);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('galerie'), "get");
        } else {
            $content = $this->load->view('galerie/edit', $data, true);
            $this->render($content);
        }
    }

    /**
     * Page New Gallery
     * 
     */
//    public function delete() {
//        if ($this->input->post()) {
//            $em = $this->doctrine->em;
//            $id = $this->input->post('id');
//            $galerie = $em->getRepository('Entities\Galerie')->findOneBy(['id' => $id]);
//            $alert = $alert = [
//                'type' => 'success',
//                'msg' => '<strong><i class="fa fa-check"></i></strong> L\'album ' . $galerie->getTitle() . ' a été supprimée avec succès.'
//            ];
//            $em->remove($galerie);
//            $em->flush();
//            $this->session->set_flashdata('flash_msg', $alert);
//        }
//    }
    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $title = $this->input->post('title');
            $alert = $em->getRepository('Entities\Galerie')->delete((int) $id, $title);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }
    
    public function changeDisplay($id) {
        $em = $this->doctrine->em;
        $output_val = $em->getRepository('Entities\Galerie')->switchState($id);
        echo $output_val;
    }

}

/* End of file main.php */

