<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Educations extends MY_Controller {

    public function liste() {

        $em = $this->doctrine->em;

        $this->local_meta = [
            'title' => 'Éducation',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            js_url() . 'educations.js'
        ];
        $this->local_stylesheets = [];
        $this->local_scripts .= 'var educations = new Educations(params);' . chr(13);
        $this->local_scripts .= 'educations.init();' . chr(13);
        $educations = $em->getRepository('Entities\Education')->get();

        $data = [
            'user' => $this->_getUser(),
            'educations' => $educations
        ];
        $content = $this->load->view('educations/educations', $data, TRUE);
        $this->render($content);
    }

    public function add() {
        $em = $this->doctrine->em;
        $this->load->helper('slug_helper');
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->local_meta = [
            'title' => 'Ajouter Éducation',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
        ];
        $this->local_stylesheets = [
        ];

        $this->form_validation->set_rules('educations[years]', 'Years', 'required|trim');
        $this->form_validation->set_rules('educations[place]', 'Place', 'required|trim');
        $this->form_validation->set_rules('educations[title]', 'Title', 'required|trim');
        $this->form_validation->set_rules('educations[description]', 'Description', 'required|trim');
        $this->form_validation->set_rules('educations[position]', 'Position', 'required|numeric|trim');
        $data = [
            'user' => $this->_getUser(),
        ];
        if ($this->form_validation->run() != false) {
            $education = $this->input->post('educations');

            $alert = $em->getRepository('Entities\Education')->addEducation($education);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('educations'), 'get');
        } else {
            $content = $this->load->view('educations/add', $data, true);
            $this->render($content);
        }
    }

    public function update($id) {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper('slug_helper');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Éducation',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_stylesheets = [
        ];
        $this->local_javascripts = [
        ];

        $this->form_validation->set_rules('educations[years]', 'Years', 'required|trim');
        $this->form_validation->set_rules('educations[place]', 'Place', 'required|trim');
        $this->form_validation->set_rules('educations[title]', 'Title', 'required|trim');
        $this->form_validation->set_rules('educations[description]', 'Description', 'required|trim');
        $this->form_validation->set_rules('educations[position]', 'Position', 'required|numeric|trim');
        
        $entity = $em->getRepository('Entities\Education')->getById($id);
        $data = [
            'user' => $this->_getUser(),
            'educations' => $entity,
        ];
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $education = $this->input->post('educations');

            $alert = $em->getRepository('Entities\Education')->update($id, $education);
            $this->session->set_flashdata('flash_msg', $alert);

            redirect(site_url('educations'), "get");
        } else {
            $content = $this->load->view('educations/edit', $data, true);
            $this->render($content);
        }
    }

    public function delete() {
        if ($this->input->post()) {
            $em = $this->doctrine->em;
            $id = $this->input->post('id');
            $name = $this->input->post('name');
            $alert = $em->getRepository('Entities\Education')->delete((int) $id, $name);
            $this->session->set_flashdata('flash_msg', $alert);
        }
    }

}
