<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
if (PHP_SAPI !== 'cli')
    exit('No web access allowed');

class Defaults extends CI_Controller {

    /**
     * Conctructor
     * 
     * @return boolean
     */
    public function __construct() {
        parent::__construct();
        if (_environment !== 'development') {
            exit('Action not allowed.');
        }
    }

    /**
     * Generate default database values
     */
    public function generate() {
        echo "Generating default database entries...\n";
        $em = $this->doctrine->em;
        // Create Default Users
        $em->getRepository('Entities\User')->dumpUsers();
        
        // Create Default Profile Informations
        $em->getRepository('Entities\Profile')->dumpProfile();
        
        // Create Default Picture
        $em->getRepository('Entities\Picture')->dumpPicture();
        
        // Create Default CV PDF
        $em->getRepository('Entities\Cvpdf')->dumpCvPdf();
        
        // Create Default Social link
        $em->getRepository('Entities\Social')->dumpSocial();
        
        // Create Default Service Informations
        $em->getRepository('Entities\Service')->dumpService();
        
        // Create Default Education Informations
        $em->getRepository('Entities\Education')->dumpEducation();
        
        // Create Default Experience Informations
        $em->getRepository('Entities\Experience')->dumpExperience();
        
        // Create Default Skill Informations
        $em->getRepository('Entities\Skill')->dumpSkill();
        
        // Create Default Slider Informations
        $em->getRepository('Entities\Slider')->dumpSlider();
        
        // Create Default Project
        $em->getRepository('Entities\Project')->dumpProject();
        echo "Database default entries generated successfully!\n";
    }

}

/* End of file welcome.php */
/* Location: ./src/admin/controllers/default.php */
