<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cvpdf extends MY_Controller {

    public function update() {
        $this->load->helper('form');
        $this->load->library('form_validation');
        $em = $this->doctrine->em;
        $this->local_meta = [
            'title' => 'Modifier Le CV',
            'keywords' => 'Ferchichi Seifeddine, Seif, Seifedine, Ferchichi',
            'description' => '',
            'author' => 'Ferchichi Seifeddine'
        ];
        $this->local_javascripts = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.js',
            js_url() . 'resource.js',
            js_url() . 'cvpdf.js'
        ];
        $this->local_stylesheets = [
            theme_url() . 'assets/bootstrap-fileupload/bootstrap-fileupload.css',
            css_url() . 'resource.css',
        ];
        $this->local_scripts .= 'var cvpdf = new Cvpdf(params);' . chr(13);
        $this->local_scripts .= 'cvpdf.init();' . chr(13);
        
        $cv = $em->getRepository('Entities\Cvpdf')->get();
        $data = [
            'cv' => $cv,
            'user' => $this->_getUser(),
        ];
        
        $this->form_validation->set_rules('resource', 'Resource', 'required');
        
        if ($this->form_validation->run() != FALSE) {
            $em = $this->doctrine->em;
            $thumb_id = $this->input->post('resource');
            
            $alert = $em->getRepository('Entities\Cvpdf')->update($thumb_id);
            $this->session->set_flashdata('flash_msg', $alert);
            redirect(site_url('cv-pdf'), 'get');
        } else {
            $content = $this->load->view('cvpdf/edit', $data, true);
            $this->render($content);
        }
    }
   
}
