<?php

namespace GestionBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class VersionType extends AbstractType {

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('version')
                ->add('comp', 'entity', [
                    'label' => 'Composant ',
                    'class' => 'GestionBundle\Entity\Composant',
                    'property' => 'titre',
                    'label_attr' => [],
                    'attr' => []
                ])
                ->add('prod', 'entity', [
                    'label' => 'Produit ',
                    'class' => 'GestionBundle\Entity\Produit',
                    'property' => 'titre',
                    'label_attr' => [],
                    'attr' => []
                ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'GestionBundle\Entity\Version'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix() {
        return 'gestionbundle_version';
    }

}
