<?php

namespace GestionBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use GestionBundle\Form\VersionType;

class ComposantType extends AbstractType {

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('titre')
                ->add('type', 'choice', array(
                    'label' => 'type',
                    'label_attr' => [
                        'class' => ''
                    ],
                    'choices' => array(
                        '' => '-- Type -- ',
                        'Open Source' => 'Open Source',
                        'Acheté' => 'Acheté',
                        'Développé en interne' => 'Développé en interne',
                    ),
                    'attr' => [
                        
                    ]
                ))
                ->add('nature', 'choice', array(
                    'label' => 'nature',
                    'label_attr' => [
                        'class' => ''
                    ],
                    'choices' => array(
                        '' => '-- Nature -- ',
                        'exe' => 'exe',
                        'lib' => 'lib',
                        'src' => 'src',
                    ),
                    'attr' => [
                        
                    ]
                ))
                ->add('licence')
                ->add('cout')
                ->add('version', new VersionType())
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'GestionBundle\Entity\Composant'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix() {
        return 'gestionbundle_composant';
    }

}
