<?php

namespace GestionBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Composant
 */
class Composant
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var string
     */
    private $titre;

    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $nature;

    /**
     * @var string
     */
    private $licence;

    /**
     * @var float
     */
    private $cout;

    /**
     * @var \GestionBundle\Entity\Version
     */
    private $version;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set titre
     *
     * @param string $titre
     * @return Composant
     */
    public function setTitre($titre)
    {
        $this->titre = $titre;

        return $this;
    }

    /**
     * Get titre
     *
     * @return string 
     */
    public function getTitre()
    {
        return $this->titre;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return Composant
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set nature
     *
     * @param string $nature
     * @return Composant
     */
    public function setNature($nature)
    {
        $this->nature = $nature;

        return $this;
    }

    /**
     * Get nature
     *
     * @return string 
     */
    public function getNature()
    {
        return $this->nature;
    }

    /**
     * Set licence
     *
     * @param string $licence
     * @return Composant
     */
    public function setLicence($licence)
    {
        $this->licence = $licence;

        return $this;
    }

    /**
     * Get licence
     *
     * @return string 
     */
    public function getLicence()
    {
        return $this->licence;
    }

    /**
     * Set cout
     *
     * @param float $cout
     * @return Composant
     */
    public function setCout($cout)
    {
        $this->cout = $cout;

        return $this;
    }

    /**
     * Get cout
     *
     * @return float 
     */
    public function getCout()
    {
        return $this->cout;
    }

    /**
     * Set version
     *
     * @param \GestionBundle\Entity\Version $version
     * @return Composant
     */
    public function setVersion(\GestionBundle\Entity\Version $version = null)
    {
        $this->version = $version;

        return $this;
    }

    /**
     * Get version
     *
     * @return \GestionBundle\Entity\Version 
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $vr;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->vr = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add vr
     *
     * @param \GestionBundle\Entity\Version $vr
     * @return Composant
     */
    public function addVr(\GestionBundle\Entity\Version $vr)
    {
        $this->vr[] = $vr;

        return $this;
    }

    /**
     * Remove vr
     *
     * @param \GestionBundle\Entity\Version $vr
     */
    public function removeVr(\GestionBundle\Entity\Version $vr)
    {
        $this->vr->removeElement($vr);
    }

    /**
     * Get vr
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getVr()
    {
        return $this->vr;
    }
}
